/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.packs.DelegatableResourcePack;
import net.minecraftforge.fml.packs.DelegatingResourcePack;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;

public class FastResourceAccess {
    private static final Field DelegatingResourcePack_delegates;

    public static boolean hasResource(IResourceManager in, ResourceLocation loc) {
        if (in instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager reloadable = (SimpleReloadableResourceManager)in;
            FallbackResourceManager forNamespace = (FallbackResourceManager)reloadable.field_199014_c.get(loc.func_110624_b());
            if (forNamespace != null) {
                return FastResourceAccess.hasResourceFallback(forNamespace, loc);
            }
            return false;
        }
        if (in instanceof FallbackResourceManager) {
            return FastResourceAccess.hasResourceFallback((FallbackResourceManager)in, loc);
        }
        return in.func_219533_b(loc);
    }

    public static IResource getResource(IResourceManager in, ResourceLocation loc) throws IOException {
        if (in instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager reloadable = (SimpleReloadableResourceManager)in;
            FallbackResourceManager forNamespace = (FallbackResourceManager)reloadable.field_199014_c.get(loc.func_110624_b());
            if (forNamespace != null) {
                return FastResourceAccess.getResourceFallback(forNamespace, loc);
            }
            throw new FileNotFoundException(loc.toString());
        }
        if (in instanceof FallbackResourceManager) {
            return FastResourceAccess.getResourceFallback((FallbackResourceManager)in, loc);
        }
        return in.func_199002_a(loc);
    }

    @Nonnull
    public static IResource getResourceFallback(FallbackResourceManager base, @Nonnull ResourceLocation resourceLocationIn) throws IOException {
        for (int i = base.field_199023_a.size() - 1; i >= 0; --i) {
            IResourcePack currentPack = (IResourcePack)base.field_199023_a.get(i);
            InputStream stream = FastResourceAccess.applyGuessing(currentPack, resourceLocationIn, (rp, rl) -> {
                try {
                    return rp.func_195761_a(ResourcePackType.CLIENT_RESOURCES, rl);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, null);
            if (stream == null) continue;
            return new SimpleResource(currentPack.func_195762_a(), resourceLocationIn, stream, null);
        }
        throw new FileNotFoundException(resourceLocationIn.toString());
    }

    public static boolean hasResourceFallback(FallbackResourceManager base, @Nonnull ResourceLocation resourceLocationIn) {
        for (int i = base.field_199023_a.size() - 1; i >= 0; --i) {
            IResourcePack currentPack = (IResourcePack)base.field_199023_a.get(i);
            if (!FastResourceAccess.applyGuessing(currentPack, resourceLocationIn, (rp, rl) -> true, false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static List<DelegatableResourcePack> getDelegates(DelegatingResourcePack pack) {
        try {
            return (List)DelegatingResourcePack_delegates.get(pack);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T applyGuessing(IResourcePack pack, ResourceLocation loc, BiFunction<IResourcePack, ResourceLocation, T> func, T defaultRet) {
        if (DelegatingResourcePack_delegates != null && pack instanceof DelegatingResourcePack) {
            List<DelegatableResourcePack> delegates = FastResourceAccess.getDelegates((DelegatingResourcePack)pack);
            DelegatableResourcePack guessed = null;
            for (DelegatableResourcePack subPack : delegates) {
                if (!(subPack instanceof ModFileResourcePack)) continue;
                ModFileResourcePack mod = (ModFileResourcePack)subPack;
                for (IModInfo info : mod.getModFile().getModInfos()) {
                    if (!info.getModId().equals(loc.func_110624_b())) continue;
                    guessed = subPack;
                    break;
                }
                if (guessed == null) continue;
                if (!subPack.func_195764_b(ResourcePackType.CLIENT_RESOURCES, loc)) break;
                return func.apply((IResourcePack)subPack, loc);
            }
            for (DelegatableResourcePack subPack : delegates) {
                if (subPack == guessed || !subPack.func_195764_b(ResourcePackType.CLIENT_RESOURCES, loc)) continue;
                return func.apply((IResourcePack)subPack, loc);
            }
            return defaultRet;
        }
        if (pack.func_195764_b(ResourcePackType.CLIENT_RESOURCES, loc)) {
            return func.apply(pack, loc);
        }
        return defaultRet;
    }

    static {
        Field delegates;
        try {
            delegates = DelegatingResourcePack.class.getDeclaredField("delegates");
            delegates.setAccessible(true);
            if (delegates.getType() != List.class) {
                delegates = null;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            delegates = null;
        }
        DelegatingResourcePack_delegates = delegates;
    }
}

