/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ManualElementCrafting
extends SpecialManualElements {
    private Object[] recipeRows;
    private List<PositionedItemStack[]>[] recipeLayout;
    private int[] recipePage;
    private int[] heightPixels;

    public ManualElementCrafting(ManualInstance manual, Object ... stacks) {
        super(manual);
        this.recipeRows = stacks;
        this.recipePage = new int[stacks.length];
        this.heightPixels = new int[stacks.length];
        this.recipeLayout = new List[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            this.recipeLayout[i] = new ArrayList<PositionedItemStack[]>();
        }
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        this.providedItems.clear();
        for (int iStack = 0; iStack < this.recipeRows.length; ++iStack) {
            this.recipeLayout[iStack].clear();
            Object stack = this.recipeRows[iStack];
            if (stack instanceof PositionedItemStack[]) {
                this.addFixedRecipe(iStack, (PositionedItemStack[])stack);
                continue;
            }
            if (stack instanceof Object[]) {
                for (Object subStack : (Object[])stack) {
                    if (subStack instanceof PositionedItemStack[]) {
                        this.addFixedRecipe(iStack, (PositionedItemStack[])subStack);
                        continue;
                    }
                    this.checkAllRecipesFor(subStack, iStack);
                }
                continue;
            }
            this.checkAllRecipesFor(stack, iStack);
        }
    }

    private void checkAllRecipesFor(Object stack, int recipeIndex) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        Map recipes = recipeManager.func_215366_a(IRecipeType.field_222149_a);
        if (stack instanceof ResourceLocation) {
            IRecipe recipe = (IRecipe)recipes.get(stack);
            if (recipe != null) {
                this.checkRecipe((IRecipe<CraftingInventory>)recipe, stack, recipeIndex);
            }
        } else {
            for (IRecipe recipe : recipes.values()) {
                this.checkRecipe((IRecipe<CraftingInventory>)recipe, stack, recipeIndex);
            }
        }
    }

    private void checkRecipe(IRecipe<CraftingInventory> rec, Object stack, int recipeIndex) {
        boolean matches;
        boolean bl = matches = !rec.func_77571_b().func_190926_b() && ManualUtils.stackMatchesObject(rec.func_77571_b(), stack);
        if (!matches && stack instanceof ResourceLocation && stack.equals(rec.func_199560_c())) {
            matches = true;
        }
        if (matches) {
            int recipeHeight;
            int recipeWidth;
            NonNullList ingredientsPre = rec.func_192400_c();
            if (rec instanceof ShapelessRecipe) {
                recipeWidth = MathHelper.func_76125_a((int)ingredientsPre.size(), (int)1, (int)3);
                recipeHeight = (ingredientsPre.size() - 1) / 3 + 1;
            } else if (rec instanceof IShapedRecipe) {
                recipeWidth = ((IShapedRecipe)rec).getRecipeWidth();
                recipeHeight = ((IShapedRecipe)rec).getRecipeHeight();
            } else {
                return;
            }
            int yOffset = (this.heightPixels[recipeIndex] - 18 * recipeHeight) / 2;
            if (yOffset < 0) {
                yOffset = 0;
            }
            PositionedItemStack[] pIngredients = new PositionedItemStack[ingredientsPre.size() + 1];
            int xBase = (120 - (recipeWidth + 2) * 18) / 2;
            for (int heightPos = 0; heightPos < recipeHeight; ++heightPos) {
                for (int widthPos = 0; widthPos < recipeWidth; ++widthPos) {
                    int index = heightPos * recipeWidth + widthPos;
                    if (index >= ingredientsPre.size()) continue;
                    pIngredients[index] = new PositionedItemStack(ingredientsPre.get(index), xBase + widthPos * 18, heightPos * 18 + yOffset);
                }
            }
            pIngredients[pIngredients.length - 1] = new PositionedItemStack(rec.func_77571_b(), xBase + recipeWidth * 18 + 18, recipeHeight * 9 - 8 + yOffset);
            if (this.heightPixels[recipeIndex] < recipeHeight * 18) {
                this.heightPixels[recipeIndex] = recipeHeight * 18;
                for (int prevId = 0; prevId <= recipeIndex; ++prevId) {
                    for (PositionedItemStack[] oldStacks : this.recipeLayout[prevId]) {
                        for (PositionedItemStack oldStack : oldStacks) {
                            oldStack.y += yOffset;
                        }
                    }
                }
            }
            this.recipeLayout[recipeIndex].add(pIngredients);
            this.addProvidedItem(rec.func_77571_b());
        }
    }

    private void addFixedRecipe(int index, PositionedItemStack[] recipe) {
        int height = 0;
        for (PositionedItemStack stack : recipe) {
            if (stack.y <= height) continue;
            height = stack.y;
        }
        if (this.heightPixels[index] < (height += 18)) {
            int offset = (height - this.heightPixels[index]) / 2;
            this.heightPixels[index] = height;
            for (int prevId = 0; prevId <= index; ++prevId) {
                for (PositionedItemStack[] oldStacks : this.recipeLayout[prevId]) {
                    for (PositionedItemStack oldStack : oldStacks) {
                        oldStack.y += offset;
                    }
                }
            }
        } else {
            int offset = (this.heightPixels[index] - height) / 2;
            for (PositionedItemStack stack : recipe) {
                stack.y += offset;
            }
        }
        this.recipeLayout[index].add(recipe);
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        int recipeYOffset = 0;
        for (int i = 0; i < this.recipeRows.length; ++i) {
            if (this.recipeLayout[i].size() > 1) {
                int iFinal = i;
                pageButtons.add(new GuiButtonManualNavigation(gui, x - 2, y + recipeYOffset + this.heightPixels[i] / 2 - 5, 8, 10, 0, btn -> {
                    int n = iFinal;
                    this.recipePage[n] = this.recipePage[n] - 1;
                    if (this.recipePage[iFinal] < 0) {
                        this.recipePage[iFinal] = this.recipeLayout[iFinal].size() - 1;
                    }
                }));
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 122 - 16, y + recipeYOffset + this.heightPixels[i] / 2 - 5, 8, 10, 1, btn -> {
                    int n = iFinal;
                    this.recipePage[n] = this.recipePage[n] + 1;
                    if (this.recipePage[iFinal] >= this.recipeLayout[iFinal].size()) {
                        this.recipePage[iFinal] = 0;
                    }
                }));
            }
            if (this.recipeLayout[i].size() <= 0) continue;
            recipeYOffset += this.heightPixels[i] + 8;
        }
        super.onOpened(gui, x, y + recipeYOffset - 2, pageButtons);
    }

    @Override
    public void render(ManualScreen gui, int x, int y, int mx, int my) {
        List<PositionedItemStack[]> rList;
        int i;
        RenderSystem.enableRescaleNormal();
        RenderHelper.func_227780_a_();
        int totalYOff = 0;
        this.highlighted = ItemStack.field_190927_a;
        MatrixStack transform = new MatrixStack();
        for (i = 0; i < this.recipeRows.length; ++i) {
            rList = this.recipeLayout[i];
            if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= rList.size()) continue;
            int maxX = 0;
            PositionedItemStack[] positionedItemStackArray = rList.get(this.recipePage[i]);
            int n = positionedItemStackArray.length;
            for (int j = 0; j < n; ++j) {
                PositionedItemStack pstack = positionedItemStackArray[j];
                if (pstack == null) continue;
                if (pstack.x > maxX) {
                    maxX = pstack.x;
                }
                AbstractGui.fill((int)(x + pstack.x), (int)(y + totalYOff + pstack.y), (int)(x + pstack.x + 16), (int)(y + totalYOff + pstack.y + 16), (int)0x33666666);
            }
            IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            ManualUtils.drawTexturedRect(transform, (IRenderTypeBuffer)buffers, this.manual.texture, x + maxX - 17, y + totalYOff + this.heightPixels[i] / 2 - 5, 16, 10, 0.0f, 0.0625f, 0.8828125f, 0.921875f);
            buffers.func_228461_a_();
            totalYOff += this.heightPixels[i] + 8;
        }
        totalYOff = 0;
        for (i = 0; i < this.recipeLayout.length; ++i) {
            rList = this.recipeLayout[i];
            if (rList.isEmpty() || this.recipePage[i] < 0 || this.recipePage[i] >= rList.size()) continue;
            for (PositionedItemStack pstack : rList.get(this.recipePage[i])) {
                if (pstack == null || pstack.getStack().func_190926_b()) continue;
                ManualUtils.renderItem().func_180450_b(pstack.getStack(), x + pstack.x, y + totalYOff + pstack.y);
                ManualUtils.renderItem().func_180453_a(this.manual.fontRenderer(), pstack.getStack(), x + pstack.x, y + totalYOff + pstack.y, null);
                if (mx < x + pstack.x || mx >= x + pstack.x + 16 || my < y + totalYOff + pstack.y || my >= y + totalYOff + pstack.y + 16) continue;
                this.highlighted = pstack.getStack();
            }
            totalYOff += this.heightPixels[i] + 8;
        }
        this.renderHighlightedTooltip(gui, mx, my);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        for (Object stack : this.recipeRows) {
            if (stack instanceof Object[]) {
                for (Object subStack : (Object[])stack) {
                    if (!(subStack instanceof ItemStack) || !ManualUtils.listStack(searchTag, (ItemStack)subStack)) continue;
                    return true;
                }
                continue;
            }
            if (!(stack instanceof ItemStack) || !ManualUtils.listStack(searchTag, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPixelsTaken() {
        int yOff = 0;
        for (int heightPixel : this.heightPixels) {
            yOff += heightPixel + 8;
        }
        return yOff;
    }
}

