/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import blusunrize.lib.manual.links.EntryWithLinks;
import blusunrize.lib.manual.links.Link;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class TextSplitter {
    public static final String START = "start";
    private final Function<String, Integer> width;
    private final int lineWidth;
    private final IntSupplier pixelsPerLine;
    private final Map<String, Map<Integer, SpecialManualElement>> specialByAnchor = new HashMap<String, Map<Integer, SpecialManualElement>>();
    private final Function<String, String> tokenTransform;
    private final int pixelsPerPage;

    public TextSplitter(Function<String, Integer> w, int lineWidthPixel, int pageHeightPixel, IntSupplier pixelsPerLine, Function<String, String> tokenTransform) {
        this.width = w;
        this.lineWidth = lineWidthPixel;
        this.pixelsPerPage = pageHeightPixel;
        this.pixelsPerLine = pixelsPerLine;
        this.tokenTransform = tokenTransform;
        this.clearSpecialByAnchor();
    }

    public TextSplitter(ManualInstance m) {
        this(m, s -> s);
    }

    public TextSplitter(ManualInstance m, Function<String, String> tokenTransform) {
        this(m.fontRenderer(), m.pageWidth, m.pageHeight, tokenTransform.andThen(s -> {
            String extraFormat = TextFormatting.BOLD.toString();
            if (m.improveReadability() && s.charAt(0) != '<' && !s.trim().isEmpty()) {
                for (TextFormatting f : TextFormatting.values()) {
                    if (f.func_96301_b()) continue;
                    s = s.replace(f.toString(), f.toString() + extraFormat);
                }
                s = extraFormat + s;
            }
            return s;
        }));
    }

    public TextSplitter(FontRenderer fontRenderer, int width, int height, Function<String, String> tokenTransform) {
        this(arg_0 -> ((FontRenderer)fontRenderer).func_78256_a(arg_0), width, height, () -> {
            fontRenderer.getClass();
            return 9;
        }, tokenTransform);
    }

    public void clearSpecialByAnchor() {
        this.specialByAnchor.clear();
        this.specialByAnchor.put(START, new HashMap());
    }

    public void addSpecialPage(String ref, int offset, SpecialManualElement element) {
        if (offset < 0 || ref == null || ref.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.specialByAnchor.containsKey(ref)) {
            this.specialByAnchor.put(ref, new HashMap());
        }
        this.specialByAnchor.get(ref).put(offset, element);
    }

    public SplitResult split(String in) {
        return this.split(EntryWithLinks.splitWhitespace(in).stream().map(Either::left).collect(Collectors.toList()));
    }

    public SplitResult split(List<Either<String, Link>> unsizedTokens) {
        int n;
        for (Map<Integer, SpecialManualElement> forAnchor : this.specialByAnchor.values()) {
            for (SpecialManualElement e : forAnchor.values()) {
                e.recalculateCraftingRecipes();
            }
        }
        ArrayList<List<List<SplitResult.Token>>> entry = new ArrayList<List<List<SplitResult.Token>>>();
        Object2IntOpenHashMap pageByAnchor = new Object2IntOpenHashMap();
        pageByAnchor.put((Object)START, 0);
        List<TokenWithWidth> wordsAndSpaces = this.convertToSplitterTokens(unsizedTokens);
        NextPageData pageOverflow = new NextPageData();
        while (pageOverflow != null && pageOverflow.topLine != null) {
            Page nextPage = this.parsePage(pageOverflow, wordsAndSpaces, arg_0 -> this.lambda$split$3(entry, (Object2IntMap)pageByAnchor, arg_0), arg_0 -> this.lambda$split$4((Object2IntMap)pageByAnchor, entry, arg_0));
            nextPage.anchor.ifPresent(arg_0 -> TextSplitter.lambda$split$5((Object2IntMap)pageByAnchor, entry, arg_0));
            entry.add(nextPage.lines);
            pageOverflow = nextPage.nextPage;
        }
        for (List list : entry) {
            for (List line : list) {
                for (int i = 0; i < line.size(); ++i) {
                    SplitResult.Token t = (SplitResult.Token)line.get(i);
                    line.set(i, ((SplitResult.Token)line.get(i)).replace('\u00a0', ' '));
                }
            }
        }
        Int2ObjectOpenHashMap specialByPage = new Int2ObjectOpenHashMap();
        boolean bl = false;
        for (Object2IntMap.Entry forAnchor : pageByAnchor.object2IntEntrySet()) {
            for (Map.Entry<Integer, SpecialManualElement> element : this.getElements((String)forAnchor.getKey()).entrySet()) {
                int page = forAnchor.getIntValue() + element.getKey();
                Preconditions.checkState((!specialByPage.containsKey(page) ? 1 : 0) != 0);
                specialByPage.put(page, (Object)element.getValue());
                if (page <= n) continue;
                n = page;
            }
        }
        while (entry.size() <= n) {
            entry.add(new ArrayList());
        }
        return new SplitResult(entry, (Object2IntMap<String>)pageByAnchor, (Int2ObjectMap<SpecialManualElement>)specialByPage);
    }

    private boolean noCollidingElements(String newAnchor, int anchorPage, Object2IntMap<String> pageByAnchor) {
        IntArraySet newSpecials = new IntArraySet();
        ObjectIterator objectIterator = this.getElements(newAnchor).keySet().iterator();
        while (objectIterator.hasNext()) {
            int offset = objectIterator.next();
            newSpecials.add(offset + anchorPage);
        }
        for (Object2IntMap.Entry e : pageByAnchor.object2IntEntrySet()) {
            for (int offset : this.getElements((String)e.getKey()).keySet()) {
                if (!newSpecials.contains(e.getIntValue() + offset)) continue;
                return false;
            }
        }
        return true;
    }

    private Optional<SpecialManualElement> findElement(Object2IntMap<String> pageByAnchor, int newAnchorPage, Optional<String> newAnchor) {
        Map<Integer, SpecialManualElement> forNewAnchor;
        if (newAnchor.isPresent() && (forNewAnchor = this.getElements(newAnchor.get())).containsKey(0)) {
            return Optional.of(forNewAnchor.get(0));
        }
        for (Object2IntMap.Entry e : pageByAnchor.object2IntEntrySet()) {
            int offset;
            Map<Integer, SpecialManualElement> forAnchor = this.getElements((String)e.getKey());
            if (!forAnchor.containsKey(offset = newAnchorPage - e.getIntValue())) continue;
            return Optional.of(forAnchor.get(offset));
        }
        return Optional.empty();
    }

    private Map<Integer, SpecialManualElement> getElements(String anchor) {
        if (!this.specialByAnchor.containsKey(anchor)) {
            IELogger.warn("Tried to access invalid key \"" + anchor + "\"");
            return ImmutableMap.of();
        }
        return this.specialByAnchor.get(anchor);
    }

    private Page parsePage(NextPageData overflow, List<TokenWithWidth> wordsAndSpaces, Predicate<String> canPlaceAnchor, Function<Optional<String>, Integer> getLines) {
        ArrayList<List<SplitResult.Token>> page = new ArrayList<List<SplitResult.Token>>();
        NextLineData lineOverflow = overflow.topLine;
        Optional anchorOnPage = Optional.empty();
        while (page.size() < getLines.apply(anchorOnPage) && lineOverflow != null) {
            Optional finalAnchorOnPage = anchorOnPage;
            Function<String, AnchorViability> getAnchorViability = anchor -> {
                if (finalAnchorOnPage.isPresent()) {
                    return AnchorViability.NOT_VALID;
                }
                if (!canPlaceAnchor.test((String)anchor)) {
                    return AnchorViability.NOT_VALID;
                }
                if (page.size() + 1 > (Integer)getLines.apply(Optional.of(anchor))) {
                    return AnchorViability.VALID_IF_ALONE;
                }
                return AnchorViability.VALID;
            };
            Line next = this.parseLine(lineOverflow, getAnchorViability, wordsAndSpaces);
            if (next.anchorBeforeLine.isPresent()) {
                String newAnchor = (String)next.anchorBeforeLine.get();
                AnchorViability viability = getAnchorViability.apply(newAnchor);
                Preconditions.checkState((viability != AnchorViability.NOT_VALID ? 1 : 0) != 0);
                if (viability == AnchorViability.VALID_IF_ALONE && !page.isEmpty()) break;
                anchorOnPage = next.anchorBeforeLine;
            }
            if (!page.isEmpty() || !next.line.isEmpty()) {
                page.add(next.line);
            }
            if ((lineOverflow = next.overflow) == null || !lineOverflow.putOnNewPage) continue;
            break;
        }
        while (!page.isEmpty() && ((List)page.get(page.size() - 1)).stream().allMatch(t -> t.getText().trim().isEmpty())) {
            page.remove(page.size() - 1);
        }
        return new Page(page, anchorOnPage, lineOverflow);
    }

    private Line parseLine(NextLineData lastOverflow, Function<String, AnchorViability> canPlaceAnchor, List<TokenWithWidth> wordsAndSpaces) {
        TokenWithWidth token;
        int currentWidth;
        int pos = lastOverflow.firstToken;
        Optional<String> anchorBeforeLine = Optional.empty();
        ArrayList<TokenWithWidth> lineTokens = new ArrayList<TokenWithWidth>();
        if (!lastOverflow.overflow.getText().isEmpty()) {
            int overflowLength = this.getWidth(lastOverflow.overflow.getText());
            lineTokens.add(new TokenWithWidth(lastOverflow.overflow, overflowLength));
            currentWidth = overflowLength;
        } else {
            currentWidth = 0;
        }
        while (pos < wordsAndSpaces.size() && currentWidth < this.lineWidth && (currentWidth + (token = wordsAndSpaces.get(pos)).width <= this.lineWidth || currentWidth == 0)) {
            if (token.getText().equals("<np>")) {
                return new Line(lineTokens, pos + 1, true, anchorBeforeLine);
            }
            if (this.isLinebreak(token.getText())) {
                return new Line(lineTokens, pos + 1, false, anchorBeforeLine);
            }
            if (token.getText().startsWith("<&") && token.getText().endsWith(">")) {
                String anchor = this.toAnchor(token.getText());
                AnchorViability allowed = canPlaceAnchor.apply(anchor);
                if (allowed == AnchorViability.VALID_IF_ALONE && currentWidth == 0) {
                    return new Line((List<TokenWithWidth>)ImmutableList.of(), pos + 1, true, Optional.of(anchor));
                }
                if (allowed != AnchorViability.VALID) {
                    return new Line(lineTokens, pos, true, Optional.empty());
                }
                anchorBeforeLine = Optional.of(anchor);
            } else if (!token.baseToken.isWhitespace() || currentWidth != 0) {
                lineTokens.add(token);
                currentWidth += token.width;
            }
            ++pos;
        }
        if ((currentWidth = this.removeEndWhitespace(lineTokens, currentWidth)) > this.lineWidth) {
            TokenWithWidth lastToken = (TokenWithWidth)lineTokens.get(lineTokens.size() - 1);
            String lastTokenText = lastToken.getText();
            int trimTo = this.lineWidth - (currentWidth - lastToken.width);
            String upToWidth = "";
            for (int i = 0; i < lastTokenText.length() && this.getWidth(upToWidth) < trimTo; ++i) {
                upToWidth = upToWidth + lastTokenText.charAt(i);
            }
            String overflowText = lastTokenText.substring(upToWidth.length());
            SplitResult.Token overflow = lastToken.baseToken.copyWithText(overflowText);
            TokenWithWidth trimmedLastToken = lastToken.copyWithText(upToWidth, trimTo);
            lineTokens.set(lineTokens.size() - 1, trimmedLastToken);
            return new Line(lineTokens, pos, false, anchorBeforeLine, overflow);
        }
        if (pos < wordsAndSpaces.size()) {
            return new Line(lineTokens, pos, false, anchorBeforeLine);
        }
        return new Line(lineTokens, null, anchorBeforeLine);
    }

    private int removeEndWhitespace(List<TokenWithWidth> tokens, int totalLength) {
        int lastIndex = tokens.size() - 1;
        while (!tokens.isEmpty() && tokens.get(lastIndex).baseToken.isWhitespace()) {
            totalLength -= tokens.remove(lastIndex--).width;
        }
        if (lastIndex >= 0) {
            TokenWithWidth lastToken = tokens.get(lastIndex);
            String newText = lastToken.getText().trim();
            StringBuilder postFormat = new StringBuilder();
            while (newText.length() >= 2 && newText.charAt(newText.length() - 2) == '\u00a7') {
                postFormat.insert(0, newText.substring(newText.length() - 2));
                newText = newText.substring(0, newText.length() - 2).trim();
            }
            if (!(newText = newText + postFormat).equals(lastToken.getText())) {
                tokens.set(lastIndex, lastToken.copyWithText(newText, this.getWidth(newText)));
            }
        }
        return totalLength;
    }

    private String toAnchor(String token) {
        return token.substring(2, token.length() - 1);
    }

    private int getWidth(String text) {
        if (this.isLinebreak(text)) {
            return 0;
        }
        switch (text) {
            case "<br>": 
            case "<np>": {
                return 0;
            }
        }
        return this.width.apply(text);
    }

    private int getLinesOnPage(Optional<SpecialManualElement> elementOnPage) {
        int pixels = this.pixelsPerPage;
        if (elementOnPage.isPresent()) {
            pixels = this.pixelsPerPage - elementOnPage.get().getPixelsTaken();
        }
        return MathHelper.func_76128_c((double)((double)pixels / (double)this.pixelsPerLine.getAsInt()));
    }

    private List<TokenWithWidth> convertToSplitterTokens(List<Either<String, Link>> rawTokens) {
        ArrayList<TokenWithWidth> ret = new ArrayList<TokenWithWidth>(rawTokens.size());
        for (Either<String, Link> e : rawTokens) {
            e.ifLeft(s -> {
                String transformed = this.tokenTransform.apply((String)s);
                ret.add(new TokenWithWidth(Either.left((Object)transformed), this.getWidth(transformed)));
            });
            e.ifRight(l -> l.getParts().stream().map(this.tokenTransform).map(s -> new TokenWithWidth(Either.right((Object)new SplitResult.LinkPart((Link)l, (String)s)), this.getWidth((String)s))).forEach(ret::add));
        }
        return ret;
    }

    private boolean isLinebreak(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$split$5(Object2IntMap pageByAnchor, List entry, String anchor) {
        pageByAnchor.put((Object)anchor, entry.size());
    }

    private /* synthetic */ Integer lambda$split$4(Object2IntMap pageByAnchor, List entry, Optional str) {
        Optional<SpecialManualElement> element = this.findElement((Object2IntMap<String>)pageByAnchor, entry.size(), str);
        return this.getLinesOnPage(element);
    }

    private /* synthetic */ boolean lambda$split$3(List entry, Object2IntMap pageByAnchor, String anchor) {
        return this.noCollidingElements(anchor, entry.size(), (Object2IntMap<String>)pageByAnchor);
    }

    private static class TokenWithWidth {
        private final SplitResult.Token baseToken;
        private final int width;

        private TokenWithWidth(Either<String, SplitResult.LinkPart> text, int width) {
            this(new SplitResult.Token(text), width);
        }

        private TokenWithWidth(SplitResult.Token text, int width) {
            this.baseToken = text;
            this.width = width;
        }

        public String getText() {
            return this.baseToken.getText();
        }

        public TokenWithWidth copyWithText(String text, int newWidth) {
            return new TokenWithWidth(this.baseToken.copyWithText(text), newWidth);
        }
    }

    private static enum AnchorViability {
        NOT_VALID,
        VALID,
        VALID_IF_ALONE;

    }

    private static class NextPageData {
        private final NextLineData topLine;

        private NextPageData(NextLineData topLine) {
            this.topLine = topLine;
        }

        public NextPageData() {
            this(new NextLineData(0, false, new SplitResult.Token((Either<String, SplitResult.LinkPart>)Either.left((Object)""))));
        }
    }

    private static class Page {
        private final List<List<SplitResult.Token>> lines;
        private final Optional<String> anchor;
        private final NextPageData nextPage;

        private Page(List<List<SplitResult.Token>> lines, Optional<String> anchor, NextPageData nextPage) {
            this.lines = lines;
            this.anchor = anchor;
            this.nextPage = nextPage;
        }

        public Page(List<List<SplitResult.Token>> page, Optional<String> anchor, NextLineData overflow) {
            this(page, anchor, overflow == null ? null : new NextPageData(overflow));
        }
    }

    private static class NextLineData {
        private final int firstToken;
        private final boolean putOnNewPage;
        private final SplitResult.Token overflow;

        private NextLineData(int firstToken, boolean putOnNewPage, SplitResult.Token overflow) {
            this.firstToken = firstToken;
            this.putOnNewPage = putOnNewPage;
            this.overflow = overflow;
        }
    }

    private static class Line {
        private final List<SplitResult.Token> line;
        private final NextLineData overflow;
        private final Optional<String> anchorBeforeLine;

        private Line(List<TokenWithWidth> line, NextLineData overflow, @Nullable Optional<String> anchorBeforeLine) {
            this.line = line.stream().map(t -> ((TokenWithWidth)t).baseToken).collect(Collectors.toList());
            this.overflow = overflow;
            this.anchorBeforeLine = anchorBeforeLine;
        }

        public Line(List<TokenWithWidth> line, int firstToken, boolean endPageAfterLine, Optional<String> anchorBeforeLine, SplitResult.Token textOverflow) {
            this(line, new NextLineData(firstToken, endPageAfterLine, textOverflow.copyWithText(Line.getFormattingAtEnd(line) + textOverflow.getText())), anchorBeforeLine);
        }

        public Line(List<TokenWithWidth> line, int firstToken, boolean endPageAfterLine, Optional<String> anchorBeforeLine) {
            this(line, firstToken, endPageAfterLine, anchorBeforeLine, new SplitResult.Token(""));
        }

        private static String getFormattingAtEnd(List<TokenWithWidth> tokens) {
            ArrayList<TextFormatting> ret = new ArrayList<TextFormatting>();
            for (TokenWithWidth token : tokens) {
                String tokenText = token.getText();
                int start = -1;
                while ((start = tokenText.indexOf(167, start + 1)) != -1) {
                    TextFormatting textformatting;
                    if (start >= tokenText.length() - 1 || (textformatting = TextFormatting.func_211165_a((char)tokenText.charAt(start + 1))) == null) continue;
                    if (textformatting.func_211166_f()) {
                        ret.clear();
                    }
                    if (textformatting == TextFormatting.RESET) continue;
                    ret.remove(textformatting);
                    ret.add(textformatting);
                }
            }
            return ret.stream().map(TextFormatting::toString).collect(Collectors.joining());
        }
    }
}

