/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.DoubleSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Tree<NT extends Comparable<NT>, LT extends Comparable<LT>> {
    private InnerNode<NT, LT> root;

    public Tree(NT root) {
        this.root = new InnerNode(root, null, () -> 0.0);
    }

    public Stream<LT> leafStream() {
        Stream.Builder b = Stream.builder();
        this.root.stream(b, true);
        return b.build().map(AbstractNode::getLeafData);
    }

    public InnerNode<NT, LT> getRoot() {
        return this.root;
    }

    public Stream<AbstractNode<NT, LT>> fullStream() {
        Stream.Builder b = Stream.builder();
        this.root.stream(b, false);
        return b.build();
    }

    public void sortAll() {
        this.root.resetWeights();
        this.root.sortChildren();
    }

    public static class Leaf<NT extends Comparable<NT>, LT extends Comparable<LT>>
    extends AbstractNode<NT, LT> {
        private final LT data;

        Leaf(LT data, @Nullable InnerNode<NT, LT> superNode, DoubleSupplier weight) {
            super(superNode, weight);
            this.data = data;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public LT getLeafData() {
            return this.data;
        }

        @Override
        protected void stream(Stream.Builder<AbstractNode<NT, LT>> builder, boolean leafStream) {
            builder.accept(this);
        }
    }

    public static class InnerNode<NT extends Comparable<NT>, LT extends Comparable<LT>>
    extends AbstractNode<NT, LT> {
        private final List<AbstractNode<NT, LT>> children = new ArrayList<AbstractNode<NT, LT>>();
        private final Comparator<AbstractNode<NT, LT>> compare = (n1, n2) -> {
            if (n1.isLeaf() && !n2.isLeaf()) {
                return 1;
            }
            if (!n1.isLeaf() && n2.isLeaf()) {
                return -1;
            }
            if (((AbstractNode)n1).weight != ((AbstractNode)n2).weight) {
                return Double.compare(n1.getWeight(), n2.getWeight());
            }
            if (n1.isLeaf()) {
                return n1.getLeafData().compareTo(n2.getLeafData());
            }
            return n1.getNodeData().compareTo(n2.getNodeData());
        };
        private final NT data;

        InnerNode(NT data, @Nullable InnerNode<NT, LT> superNode, DoubleSupplier weight) {
            super(superNode, weight);
            this.data = data;
        }

        @Override
        public List<AbstractNode<NT, LT>> getChildren() {
            return this.children;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public NT getNodeData() {
            return this.data;
        }

        public InnerNode<NT, LT> addNewSubnode(NT data, int weight) {
            return this.addNewSubnode(data, () -> weight);
        }

        public InnerNode<NT, LT> addNewSubnode(NT data, DoubleSupplier weight) {
            InnerNode<NT, LT> newNode = new InnerNode<NT, LT>(data, this, weight);
            this.children.add(newNode);
            return newNode;
        }

        public InnerNode<NT, LT> getOrCreateSubnode(NT data) {
            return this.getOrCreateSubnode(data, 0);
        }

        public InnerNode<NT, LT> getOrCreateSubnode(NT data, int weight) {
            return this.getOrCreateSubnode(data, () -> weight);
        }

        public InnerNode<NT, LT> getOrCreateSubnode(NT data, DoubleSupplier weight) {
            return this.getSubnode(data).orElseGet(() -> this.addNewSubnode(data, weight));
        }

        public Optional<InnerNode<NT, LT>> getSubnode(NT data) {
            for (AbstractNode<NT, LT> child : this.children) {
                if (child.isLeaf() || !data.equals(child.getNodeData())) continue;
                return Optional.of((InnerNode)child);
            }
            return Optional.empty();
        }

        public void removeLeaf(LT data) {
            this.children.removeIf(child -> child.isLeaf() && ((Leaf)child).data.equals(data));
        }

        public void removeSubnode(NT data) {
            this.children.removeIf(child -> !child.isLeaf() && ((InnerNode)child).data.equals(data));
        }

        public void addNewLeaf(LT data) {
            this.addNewLeaf(data, 0);
        }

        public void addNewLeaf(LT data, int weight) {
            this.addNewLeaf(data, () -> weight);
        }

        public void addNewLeaf(LT data, DoubleSupplier weight) {
            Leaf newLeaf = new Leaf(data, this, weight);
            this.children.add(newLeaf);
        }

        public void sortChildren() {
            this.children.sort(this.compare);
            for (AbstractNode<NT, LT> c : this.children) {
                if (!(c instanceof InnerNode)) continue;
                ((InnerNode)c).sortChildren();
            }
        }

        @Override
        protected void stream(Stream.Builder<AbstractNode<NT, LT>> builder, boolean leafStream) {
            if (!leafStream) {
                builder.accept(this);
            }
            for (AbstractNode<NT, LT> child : this.getChildren()) {
                child.stream(builder, leafStream);
            }
        }

        @Override
        void resetWeights() {
            super.resetWeights();
            this.children.forEach(AbstractNode::resetWeights);
        }
    }

    public static abstract class AbstractNode<NT extends Comparable<NT>, LT extends Comparable<LT>> {
        @Nullable
        private final InnerNode<NT, LT> superNode;
        private final DoubleSupplier weight;
        private OptionalDouble cachedWeight;

        AbstractNode(@Nullable InnerNode<NT, LT> superNode, DoubleSupplier weight) {
            this.superNode = superNode;
            this.weight = weight;
        }

        public abstract boolean isLeaf();

        public NT getNodeData() {
            return null;
        }

        public LT getLeafData() {
            return null;
        }

        public List<AbstractNode<NT, LT>> getChildren() {
            return ImmutableList.of();
        }

        @Nullable
        public InnerNode<NT, LT> getSuperNode() {
            return this.superNode;
        }

        protected abstract void stream(Stream.Builder<AbstractNode<NT, LT>> var1, boolean var2);

        public double getWeight() {
            if (!this.cachedWeight.isPresent()) {
                this.cachedWeight = OptionalDouble.of(this.weight.getAsDouble());
            }
            return this.cachedWeight.getAsDouble();
        }

        void resetWeights() {
            this.cachedWeight = OptionalDouble.empty();
        }
    }
}

