/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;

public class ClickableList
extends Button {
    private String[] headers;
    private boolean[] isCategory;
    @Nonnull
    private List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
    private float textScale;
    private final Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler;
    private int offset;
    private int maxOffset;
    private final int perPage;
    private ManualScreen gui;

    ClickableList(ManualScreen gui, int x, int y, int w, int h, float textScale, @Nonnull List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes, Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler) {
        super(x, y, w, h, "", btn -> {});
        this.gui = gui;
        this.textScale = textScale;
        this.handler = handler;
        this.perPage = (h - 8) / this.getFontHeight();
        this.setEntries(nodes);
    }

    int getFontHeight() {
        this.gui.manual.fontRenderer().getClass();
        return (int)(9.0f * this.textScale);
    }

    public void render(int mx, int my, float partialTicks) {
        if (!this.visible) {
            return;
        }
        FontRenderer fr = this.gui.manual.fontRenderer();
        int mmY = my - this.y;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)this.textScale, (float)this.textScale, (float)this.textScale);
        RenderSystem.translatef((float)((float)this.x / this.textScale), (float)((float)this.y / this.textScale), (float)0.0f);
        this.isHovered = mx >= this.x && mx < this.x + this.width && my >= this.y && my < this.y + this.height;
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            int j;
            boolean currEntryHovered;
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            int col = this.gui.manual.getTextColour();
            boolean bl = currEntryHovered = this.isHovered && mmY >= i * this.getFontHeight() && mmY < (i + 1) * this.getFontHeight();
            if (currEntryHovered) {
                col = this.gui.manual.getHighlightColour();
            }
            if (i != 0) {
                RenderSystem.translatef((float)0.0f, (float)this.getFontHeight(), (float)0.0f);
            }
            if ((j = this.offset + i) > this.headers.length - 1) {
                j = this.headers.length - 1;
            }
            String s = this.headers[j];
            if (this.isCategory[j]) {
                ManualUtils.bindTexture(this.gui.texture);
                RenderSystem.enableBlend();
                this.blit(0, 0, 11, 226 + (currEntryHovered ? 20 : 0), 5, 10);
            }
            fr.func_211126_b(s, this.isCategory[j] ? 7.0f : 0.0f, 0.0f, col);
        }
        RenderSystem.scalef((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)(1.0f / this.textScale));
        RenderSystem.popMatrix();
        if (this.maxOffset > 0) {
            int minVisibleBlack = 0x1B000000;
            int mainBarBlack = 0x28000000;
            float totalHeight = this.maxOffset * this.getFontHeight() + this.getHeight();
            float heightTopRel = (float)(this.offset * this.getFontHeight()) / totalHeight;
            float heightBottomRel = (float)(this.offset * this.getFontHeight() + this.getHeight()) / totalHeight;
            int heightTopAbs = (int)(heightTopRel * (float)this.getHeight());
            int heightBottomAbs = (int)(heightBottomRel * (float)this.getHeight());
            ClickableList.fill((int)(this.x + this.width), (int)this.y, (int)(this.x + this.width + 8), (int)(this.y + this.height), (int)0x1B000000);
            ClickableList.fill((int)(this.x + this.width + 1), (int)(this.y + heightTopAbs), (int)(this.x + this.width + 7), (int)(this.y + heightBottomAbs), (int)0x28000000);
        }
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double amount) {
        if (amount < 0.0 && this.offset < this.maxOffset) {
            ++this.offset;
            return true;
        }
        if (amount > 0.0 && this.offset > 0) {
            --this.offset;
            return true;
        }
        return false;
    }

    @Nullable
    public Tree.AbstractNode<ResourceLocation, ManualEntry> getSelected(double mx, double my) {
        if (!super.clicked(mx, my)) {
            return null;
        }
        double mmY = my - (double)this.y;
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            if (!(mmY >= (double)(i * this.getFontHeight())) || !(mmY < (double)((i + 1) * this.getFontHeight()))) continue;
            return this.nodes.get(this.offset + i);
        }
        return null;
    }

    public void onClick(double mx, double my) {
        this.handler.accept(this.getSelected(mx, my));
    }

    protected boolean clicked(double mx, double my) {
        return this.getSelected(mx, my) != null;
    }

    public void setEntries(List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes) {
        this.nodes = nodes;
        this.headers = new String[nodes.size()];
        this.isCategory = new boolean[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.headers[i] = ManualUtils.getTitleForNode(nodes.get(i), this.gui.manual);
            this.isCategory[i] = !nodes.get(i).isLeaf();
        }
        this.maxOffset = this.perPage < this.headers.length ? this.headers.length - this.perPage : 0;
        this.height = this.getFontHeight() * Math.min(this.perPage, this.headers.length);
    }
}

