/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CookingForBlockheadsConfig {
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showIngredientIcon;

        public Client(ForgeConfigSpec.Builder builder) {
            this.showIngredientIcon = builder.comment("Set to false if you don't want ingredients to be marked with a special icon in the recipe book.").translation("waystones.config.showIngredientIcon").define("showIngredientIcon", true);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue cowJarEnabled;
        public final ForgeConfigSpec.DoubleValue cowJarMilkPerTick;
        public final ForgeConfigSpec.BooleanValue sinkRequiresWater;
        public final ForgeConfigSpec.BooleanValue largeCounters;
        public final ForgeConfigSpec.BooleanValue disallowOvenAutomation;
        public final ForgeConfigSpec.DoubleValue ovenFuelTimeMultiplier;
        public final ForgeConfigSpec.DoubleValue ovenCookTimeMultiplier;
        public final ForgeConfigSpec.BooleanValue ovenRequiresCookingOil;

        public Common(ForgeConfigSpec.Builder builder) {
            this.cowJarEnabled = builder.comment("If true, a cow can be squished into a Milk Jar by dropping an anvil on top.").translation("waystones.config.cowJarEnabled").define("cowJarEnabled", true);
            this.cowJarMilkPerTick = builder.comment("The amount of milk the cow in a jar generates per tick.").translation("waystones.config.cowJarMilkPerTick").defineInRange("cowJarMilkPerTick", 0.5, 0.0, 3.4028234663852886E38);
            this.sinkRequiresWater = builder.comment("Set this to true if you'd like the sink to require water to be piped in, instead of providing infinite of it.").translation("waystones.config.sinkRequiresWater").define("sinkRequiresWater", false);
            this.largeCounters = builder.comment("Enabling this will make the kitchen counters have twice as much inventory space.").translation("waystones.config.largeCounters").define("largeCounters", false);
            this.disallowOvenAutomation = builder.comment("Set this to true if you'd like to disallow automation of the oven (pipes and such won't be able to insert/extract)").translation("waystones.config.disallowOvenAutomation").define("disallowOvenAutomation", false);
            this.ovenFuelTimeMultiplier = builder.comment("The fuel multiplier for the cooking oven. Higher values means fuel lasts longer, 1.0 is furnace default.").translation("waystones.config.ovenFuelTimeMultiplier").defineInRange("ovenFuelTimeMultiplier", (double)0.33f, (double)0.1f, 2.0);
            this.ovenCookTimeMultiplier = builder.comment("The cooking time multiplier for the cooking oven. Higher values means it will take longer.").translation("waystones.config.ovenCookTimeMultiplier").defineInRange("ovenCookTimeMultiplier", 1.0, 0.25, 9.0);
            this.ovenRequiresCookingOil = builder.comment("Set this to true if you'd like the oven to only accept cooking oil as fuel (requires Pam's Harvestcraft)").translation("waystones.config.ovenRequiresCookingOil").define("ovenRequiresCookingOil", false);
        }
    }
}

