/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.client.CachedDynamicModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.DyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cookingforblockheads", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModModels {
    public static IBakedModel milkJarLiquid;
    public static IBakedModel sinkLiquid;
    public static IBakedModel ovenDoor;
    public static IBakedModel ovenDoorHandle;
    public static IBakedModel ovenDoorActive;
    public static IBakedModel fridgeDoor;
    public static IBakedModel fridgeDoorFlipped;
    public static IBakedModel fridgeDoorLargeLower;
    public static IBakedModel fridgeDoorLargeUpper;
    public static IBakedModel fridgeDoorLargeLowerFlipped;
    public static IBakedModel fridgeDoorLargeUpperFlipped;
    public static IBakedModel[] counterDoors;
    public static IBakedModel[] counterDoorsFlipped;
    public static IBakedModel[] cabinetDoors;
    public static IBakedModel[] cabinetDoorsFlipped;

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        try {
            milkJarLiquid = ModModels.loadAndBakeModel(event, ModModels.location("block/milk_jar_liquid"));
            sinkLiquid = ModModels.loadAndBakeModel(event, ModModels.location("block/sink_liquid"));
            ovenDoor = ModModels.loadAndBakeModel(event, ModModels.location("block/oven_door"));
            ovenDoorHandle = ModModels.loadAndBakeModel(event, ModModels.location("block/oven_door_handle"));
            ovenDoorActive = ModModels.loadAndBakeModel(event, ModModels.location("block/oven_door_active"));
            fridgeDoor = ModModels.loadAndBakeModel(event, ModModels.location("block/fridge_door"));
            fridgeDoorFlipped = ModModels.loadAndBakeModel(event, ModModels.location("block/fridge_door_flipped"));
            fridgeDoorLargeLower = ModModels.loadAndBakeModel(event, ModModels.location("block/fridge_large_door_lower"));
            fridgeDoorLargeLowerFlipped = ModModels.loadAndBakeModel(event, ModModels.location("block/fridge_large_door_lower_flipped"));
            fridgeDoorLargeUpper = ModModels.loadAndBakeModel(event, ModModels.location("block/fridge_large_door_upper"));
            fridgeDoorLargeUpperFlipped = ModModels.loadAndBakeModel(event, ModModels.location("block/fridge_large_door_upper_flipped"));
            DyeColor[] colors = DyeColor.values();
            counterDoors = new IBakedModel[colors.length + 1];
            ModModels.counterDoors[0] = ModModels.loadAndBakeModel(event, ModModels.location("block/counter_door"));
            counterDoorsFlipped = new IBakedModel[colors.length + 1];
            ModModels.counterDoorsFlipped[0] = ModModels.loadAndBakeModel(event, ModModels.location("block/counter_door_flipped"));
            for (DyeColor color : colors) {
                ModModels.counterDoors[color.func_196059_a() + 1] = ModModels.loadAndBakeModel(event, ModModels.location("block/counter_door"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color)));
                ModModels.counterDoorsFlipped[color.func_196059_a() + 1] = ModModels.loadAndBakeModel(event, ModModels.location("block/counter_door_flipped"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color)));
            }
            cabinetDoors = new IBakedModel[colors.length + 1];
            ModModels.cabinetDoors[0] = ModModels.loadAndBakeModel(event, ModModels.location("block/cabinet_door"));
            cabinetDoorsFlipped = new IBakedModel[colors.length + 1];
            ModModels.cabinetDoorsFlipped[0] = ModModels.loadAndBakeModel(event, ModModels.location("block/cabinet_door_flipped"));
            for (DyeColor color : colors) {
                ModModels.cabinetDoors[color.func_196059_a() + 1] = ModModels.loadAndBakeModel(event, ModModels.location("block/cabinet_door"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color)));
                ModModels.cabinetDoorsFlipped[color.func_196059_a() + 1] = ModModels.loadAndBakeModel(event, ModModels.location("block/cabinet_door_flipped"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color)));
            }
            ModModels.registerColoredKitchenBlock(event, "block/cooking_table", ModBlocks.cookingTable);
            ResourceLocation sinkModel = ModModels.location("block/sink");
            ResourceLocation sinkFlippedModel = ModModels.location("block/sink_flipped");
            ModModels.overrideWithDynamicModel(event, ModBlocks.sink, "block/sink", it -> (Boolean)it.func_177229_b((IProperty)SinkBlock.FLIPPED) != false ? sinkFlippedModel : sinkModel, it -> {
                if (((Boolean)it.func_177229_b((IProperty)SinkBlock.HAS_COLOR)).booleanValue()) {
                    return ModModels.replaceTexture(ModModels.getColoredTerracottaTexture((DyeColor)it.func_177229_b((IProperty)SinkBlock.COLOR)));
                }
                return Collections.emptyMap();
            });
            ModModels.loadAsDynamicModel(event, ModBlocks.cuttingBoard, "block/cutting_board");
            ResourceLocation toasterModel = ModModels.location("block/toaster");
            ResourceLocation toasterActiveModel = ModModels.location("block/toaster_active");
            ModModels.overrideWithDynamicModel(event, ModBlocks.toaster, "block/toaster", it -> (Boolean)it.func_177229_b((IProperty)ToasterBlock.ACTIVE) != false ? toasterActiveModel : toasterModel, null);
            ModModels.loadAsDynamicModel(event, ModBlocks.fruitBasket, "block/fruit_basket");
            ModModels.loadAsDynamicModel(event, ModBlocks.milkJar, "block/milk_jar");
            ModModels.loadAsDynamicModel(event, ModBlocks.cowJar, "block/milk_jar");
            ResourceLocation fridgeSmallModel = ModModels.location("block/fridge");
            ResourceLocation fridgeLargeLowerModel = ModModels.location("block/fridge_large_lower");
            ResourceLocation fridgeLargeUpperModel = ModModels.location("block/fridge_large_upper");
            ModModels.overrideWithDynamicModel(event, ModBlocks.fridge, "block/fridge", it -> {
                FridgeBlock.FridgeModelType fridgeModelType = (FridgeBlock.FridgeModelType)((Object)((Object)it.func_177229_b(FridgeBlock.MODEL_TYPE)));
                switch (fridgeModelType) {
                    case LARGE_LOWER: {
                        return fridgeLargeLowerModel;
                    }
                    case LARGE_UPPER: {
                        return fridgeLargeUpperModel;
                    }
                }
                return fridgeSmallModel;
            }, null);
            ModModels.registerColoredKitchenBlock(event, "block/counter", ModBlocks.counter);
            ModModels.registerColoredKitchenBlock(event, "block/corner", ModBlocks.corner);
            ModModels.registerColoredKitchenBlock(event, "block/hanging_corner", ModBlocks.hangingCorner);
            ModModels.registerColoredKitchenBlock(event, "block/cabinet", ModBlocks.cabinet);
            ModModels.overrideWithDynamicModel(event, ModBlocks.oven, "block/oven", null, state -> {
                boolean isActive;
                String normalTexture = "cookingforblockheads:block/oven_front";
                String activeTexture = "cookingforblockheads:block/oven_front_active";
                boolean isPowered = (Boolean)state.func_177229_b((IProperty)OvenBlock.POWERED);
                if (isPowered) {
                    normalTexture = "cookingforblockheads:block/oven_front_powered";
                    activeTexture = "cookingforblockheads:block/oven_front_powered_active";
                }
                if ((isActive = ((Boolean)state.func_177229_b((IProperty)OvenBlock.ACTIVE)).booleanValue()) || isPowered) {
                    return ImmutableMap.of((Object)"ovenfront", (Object)(isActive ? activeTexture : normalTexture));
                }
                return Collections.emptyMap();
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ResourceLocation location(String path) {
        return new ResourceLocation("cookingforblockheads", path);
    }

    public static IUnbakedModel retexture(ModelBakery bakery, ResourceLocation baseModel, Map<String, String> replacedTextures) {
        HashMap<String, Either> replacedTexturesMapped = new HashMap<String, Either>();
        for (Map.Entry<String, String> entry : replacedTextures.entrySet()) {
            replacedTexturesMapped.put(entry.getKey(), Either.left((Object)new Material(AtlasTexture.field_110575_b, new ResourceLocation(entry.getValue()))));
        }
        BlockModel blockModel = new BlockModel(baseModel, Collections.emptyList(), replacedTexturesMapped, false, BlockModel.GuiLight.FRONT, ItemCameraTransforms.field_178357_a, Collections.emptyList());
        blockModel.func_225614_a_(arg_0 -> ((ModelBakery)bakery).func_209597_a(arg_0), new HashSet());
        return blockModel;
    }

    private static void registerColoredKitchenBlock(ModelBakeEvent event, String modelPath, Block block) {
        ModModels.overrideWithDynamicModel(event, block, modelPath, null, it -> {
            if (((Boolean)it.func_177229_b((IProperty)BlockKitchen.HAS_COLOR)).booleanValue()) {
                return ModModels.replaceTexture(ModModels.getColoredTerracottaTexture((DyeColor)it.func_177229_b(BlockKitchen.COLOR)));
            }
            return Collections.emptyMap();
        });
    }

    private static ImmutableMap<String, String> replaceTexture(String texturePath) {
        return ImmutableMap.builder().put((Object)"texture", (Object)texturePath).put((Object)"particle", (Object)texturePath).build();
    }

    private static String getColoredTerracottaTexture(DyeColor color) {
        return "minecraft:block/" + color.func_176610_l().toLowerCase(Locale.ENGLISH) + "_terracotta";
    }

    private static void loadAsDynamicModel(ModelBakeEvent event, Block block, String modelPath) throws Exception {
        ModModels.overrideWithDynamicModel(event, block, modelPath, null, null);
    }

    private static void overrideWithDynamicModel(ModelBakeEvent event, Block block, String modelPath, @Nullable Function<BlockState, ResourceLocation> modelFunction, @Nullable Function<BlockState, Map<String, String>> textureMapFunction) {
        ResourceLocation modelLocation = ModModels.location(modelPath);
        if (modelFunction == null) {
            modelFunction = it -> modelLocation;
        }
        CachedDynamicModel dynamicModel = new CachedDynamicModel((ModelBakery)event.getModelLoader(), modelFunction, null, textureMapFunction, modelLocation);
        ModModels.overrideModelIgnoreState(block, dynamicModel, event);
    }

    @Nullable
    private static IBakedModel loadAndBakeModel(ModelBakeEvent event, ResourceLocation resourceLocation) {
        return ModModels.loadAndBakeModel(event, resourceLocation, Collections.emptyMap());
    }

    @Nullable
    private static IBakedModel loadAndBakeModel(ModelBakeEvent event, ResourceLocation resourceLocation, Map<String, String> textureOverrides) {
        IUnbakedModel model = ModModels.retexture((ModelBakery)event.getModelLoader(), resourceLocation, textureOverrides);
        return model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)SimpleModelTransform.IDENTITY, resourceLocation);
    }

    private static void overrideModelIgnoreState(Block block, IBakedModel model, ModelBakeEvent event) {
        block.func_176194_O().func_177619_a().forEach(state -> {
            ModelResourceLocation modelLocation = BlockModelShapes.func_209554_c((BlockState)state);
            event.getModelRegistry().put(modelLocation, model);
        });
    }
}

