/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.FilenameUtils;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookContents
extends AbstractReadStateHolder {
    protected static final String DEFAULT_LANG = "en_us";
    public static final Map<ResourceLocation, Supplier<BookTemplate>> addonTemplates = new ConcurrentHashMap<ResourceLocation, Supplier<BookTemplate>>();
    public final Book book;
    public Map<ResourceLocation, BookCategory> categories = new HashMap<ResourceLocation, BookCategory>();
    public Map<ResourceLocation, BookEntry> entries = new HashMap<ResourceLocation, BookEntry>();
    public Map<ResourceLocation, Supplier<BookTemplate>> templates = new HashMap<ResourceLocation, Supplier<BookTemplate>>();
    public Map<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>> recipeMappings = new HashMap<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>>();
    private boolean errored = false;
    private Exception exception = null;
    public Deque<GuiBook> guiStack = new ArrayDeque<GuiBook>();
    public GuiBook currentGui;
    public BookIcon indexIcon;

    public BookContents(Book book) {
        this.book = book;
    }

    public boolean isErrored() {
        return this.errored;
    }

    public Exception getException() {
        return this.exception;
    }

    public Pair<BookEntry, Integer> getEntryForStack(ItemStack stack) {
        return this.recipeMappings.get(ItemStackUtil.wrapStack(stack));
    }

    public GuiBook getCurrentGui() {
        if (this.currentGui == null) {
            this.currentGui = new GuiBookLanding(this.book);
        }
        return this.currentGui;
    }

    public void openLexiconGui(GuiBook gui, boolean push) {
        if (gui.canBeOpened()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (push && mc.field_71462_r instanceof GuiBook && gui != mc.field_71462_r) {
                this.guiStack.push((GuiBook)mc.field_71462_r);
            }
            mc.func_147108_a((Screen)gui);
            gui.onFirstOpened();
        }
    }

    public String getSubtitle() {
        return this.book.getSubtitle().func_150254_d();
    }

    public void reload(boolean isOverride) {
        this.errored = false;
        if (!isOverride) {
            this.currentGui = null;
            this.guiStack.clear();
            this.categories.clear();
            this.entries.clear();
            this.templates.clear();
            this.recipeMappings.clear();
            this.templates.putAll(addonTemplates);
            this.indexIcon = this.book.indexIconRaw == null || this.book.indexIconRaw.isEmpty() ? new BookIcon(this.book.getBookItem()) : BookIcon.from(this.book.indexIconRaw);
        }
        ArrayList<ResourceLocation> foundCategories = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> foundEntries = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> foundTemplates = new ArrayList<ResourceLocation>();
        try {
            String bookName = this.book.id.func_110623_a();
            this.findFiles("categories", foundCategories);
            this.findFiles("entries", foundEntries);
            this.findFiles("templates", foundTemplates);
            foundCategories.forEach(c -> this.loadCategory((ResourceLocation)c, new ResourceLocation(c.func_110624_b(), String.format("%s/%s/%s/categories/%s.json", "patchouli_books", bookName, DEFAULT_LANG, c.func_110623_a())), this.book));
            foundEntries.stream().map(id -> this.loadEntry((ResourceLocation)id, new ResourceLocation(id.func_110624_b(), String.format("%s/%s/%s/entries/%s.json", "patchouli_books", bookName, DEFAULT_LANG, id.func_110623_a())), this.book)).filter(Optional::isPresent).map(Optional::get).forEach(b -> this.entries.put(b.getId(), (BookEntry)b));
            foundTemplates.forEach(e -> this.loadTemplate((ResourceLocation)e, new ResourceLocation(e.func_110624_b(), String.format("%s/%s/%s/templates/%s.json", "patchouli_books", bookName, DEFAULT_LANG, e.func_110623_a()))));
            this.categories.forEach((id, category) -> {
                try {
                    category.build((ResourceLocation)id);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while building category " + id, e);
                }
            });
            this.entries.values().forEach(entry -> {
                try {
                    entry.build();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error building entry " + entry.getId(), e);
                }
            });
        }
        catch (Exception e2) {
            this.exception = e2;
            this.errored = true;
            Patchouli.LOGGER.error("Error while loading contents for book {}", (Object)this.book.id, (Object)e2);
        }
    }

    protected void findFiles(String dir, List<ResourceLocation> list) {
        IModInfo mod = this.book.owner;
        String id = mod.getModId();
        BookRegistry.findFiles(mod, String.format("data/%s/%s/%s/%s/%s", id, "patchouli_books", this.book.id.func_110623_a(), DEFAULT_LANG, dir), path -> true, this.pred(id, list), false);
    }

    private BiFunction<Path, Path, Boolean> pred(String modId, List<ResourceLocation> list) {
        return (root, file) -> {
            Path rel = root.relativize((Path)file);
            String relName = rel.toString();
            if (relName.endsWith(".json")) {
                relName = FilenameUtils.removeExtension((String)FilenameUtils.separatorsToUnix((String)relName));
                ResourceLocation res = new ResourceLocation(modId, relName);
                list.add(res);
            }
            return true;
        };
    }

    private void loadCategory(ResourceLocation key, ResourceLocation res, Book book) {
        try (BufferedReader stream = this.loadLocalizedJson(res);){
            BookCategory category = (BookCategory)ClientBookRegistry.INSTANCE.gson.fromJson((Reader)stream, BookCategory.class);
            if (category == null) {
                throw new IllegalArgumentException(res + " does not exist.");
            }
            category.setBook(book);
            if (category.canAdd()) {
                this.categories.put(key, category);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<BookEntry> loadEntry(ResourceLocation id, ResourceLocation file, Book book) {
        try (BufferedReader stream = this.loadLocalizedJson(file);){
            BookEntry entry = (BookEntry)ClientBookRegistry.INSTANCE.gson.fromJson((Reader)stream, BookEntry.class);
            if (entry == null) {
                throw new IllegalArgumentException(file + " does not exist.");
            }
            entry.setBook(book);
            if (!entry.canAdd()) return Optional.empty();
            BookCategory category = entry.getCategory();
            if (category != null) {
                category.addEntry(entry);
                entry.setId(id);
                Optional<BookEntry> optional = Optional.of(entry);
                return optional;
            }
            String msg = String.format("Entry in file %s does not have a valid category.", file);
            throw new RuntimeException(msg);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void loadTemplate(ResourceLocation key, ResourceLocation res) {
        String json;
        try (BufferedReader stream = this.loadLocalizedJson(res);){
            json = stream.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Supplier<BookTemplate> supplier = () -> (BookTemplate)ClientBookRegistry.INSTANCE.gson.fromJson(json, BookTemplate.class);
        BookTemplate template = supplier.get();
        if (template == null) {
            throw new IllegalArgumentException(res + " could not be instantiated by the supplier.");
        }
        this.templates.put(key, supplier);
    }

    private BufferedReader loadLocalizedJson(ResourceLocation res) {
        ResourceLocation localized = new ResourceLocation(res.func_110624_b(), res.func_110623_a().replaceAll(DEFAULT_LANG, ClientBookRegistry.INSTANCE.currentLang));
        InputStream input = this.loadJson(localized, res);
        if (input == null) {
            throw new IllegalArgumentException(res + " does not exist.");
        }
        return new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
    }

    protected InputStream loadJson(ResourceLocation resloc, ResourceLocation fallback) {
        String path = "/data/" + resloc.func_110624_b() + "/" + resloc.func_110623_a();
        Patchouli.LOGGER.debug("Loading {}", (Object)path);
        InputStream stream = this.book.ownerClass.getResourceAsStream(path);
        if (stream != null) {
            return stream;
        }
        if (fallback != null) {
            Patchouli.LOGGER.warn("Failed to load " + resloc + ". Switching to fallback.");
            return this.loadJson(fallback, null);
        }
        return null;
    }

    @Override
    protected EntryDisplayState computeReadState() {
        Stream<EntryDisplayState> stream = this.categories.values().stream().filter(BookCategory::isRootCategory).map(AbstractReadStateHolder::getReadState);
        return BookContents.mostImportantState(stream);
    }

    public final void checkValidCurrentEntry() {
        if (!this.getCurrentGui().canBeOpened()) {
            this.currentGui = null;
            this.guiStack.clear();
        }
    }

    public final void setTopEntry(ResourceLocation entryId, int page) {
        BookEntry entry = this.entries.get(entryId);
        if (!entry.isLocked()) {
            GuiBookEntry currEntry;
            GuiBook prevGui = this.getCurrentGui();
            int spread = page / 2;
            this.currentGui = new GuiBookEntry(this.book, entry, spread);
            if (prevGui instanceof GuiBookEntry && (currEntry = (GuiBookEntry)prevGui).getEntry() == entry && currEntry.getSpread() == spread) {
                return;
            }
            entry.getBook().contents.guiStack.push(prevGui);
        }
    }
}

