/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.forgespi.language.IModInfo;
import vazkii.patchouli.api.BookContentsReloadEvent;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ExternalBookContents;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;

public class Book {
    private static final String[] ORDINAL_SUFFIXES = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    public static final ResourceLocation DEFAULT_MODEL = new ResourceLocation("patchouli", "book_brown");
    private static final ResourceLocation UNICODE_FONT_ID = new ResourceLocation("patchouli", "unicode_font");
    private static final Map<String, String> DEFAULT_MACROS = (Map)Util.func_199748_a(() -> {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("$(list", "$(li");
        ret.put("/$", "$()");
        ret.put("<br>", "$(br)");
        ret.put("$(item)", "$(#b0b)");
        ret.put("$(thing)", "$(#490)");
        return ret;
    });
    public transient BookContents contents;
    private transient boolean wasUpdated = false;
    public transient IModInfo owner;
    public transient Class<?> ownerClass;
    public transient ResourceLocation id;
    private transient ItemStack bookItem;
    public transient int textColor;
    public transient int headerColor;
    public transient int nameplateColor;
    public transient int linkColor;
    public transient int linkHoverColor;
    public transient int progressBarColor;
    public transient int progressBarBackground;
    public transient boolean isExtension = false;
    public transient List<Book> extensions = new LinkedList<Book>();
    public transient Book extensionTarget;
    public transient boolean isExternal;
    public String name = "";
    @SerializedName(value="landing_text")
    public String landingText = "patchouli.gui.lexicon.landing_info";
    @SerializedName(value="book_texture")
    public ResourceLocation bookTexture = new ResourceLocation("patchouli", "textures/gui/book_brown.png");
    @SerializedName(value="filler_texture")
    public ResourceLocation fillerTexture = new ResourceLocation("patchouli", "textures/gui/page_filler.png");
    @SerializedName(value="crafting_texture")
    public ResourceLocation craftingTexture = new ResourceLocation("patchouli", "textures/gui/crafting.png");
    public ResourceLocation model = DEFAULT_MODEL;
    @SerializedName(value="text_color")
    public String textColorRaw = "000000";
    @SerializedName(value="header_color")
    public String headerColorRaw = "333333";
    @SerializedName(value="nameplate_color")
    public String nameplateColorRaw = "FFDD00";
    @SerializedName(value="link_color")
    public String linkColorRaw = "0000EE";
    @SerializedName(value="link_hover_color")
    public String linkHoverColorRaw = "8800EE";
    @SerializedName(value="use_blocky_font")
    public boolean useBlockyFont = false;
    @SerializedName(value="progress_bar_color")
    public String progressBarColorRaw = "FFFF55";
    @SerializedName(value="progress_bar_background")
    public String progressBarBackgroundRaw = "DDDDDD";
    @SerializedName(value="open_sound")
    public ResourceLocation openSound = new ResourceLocation("patchouli", "book_open");
    @SerializedName(value="flip_sound")
    public ResourceLocation flipSound = new ResourceLocation("patchouli", "book_flip");
    @SerializedName(value="show_progress")
    public boolean showProgress = true;
    @SerializedName(value="index_icon")
    public String indexIconRaw = "";
    public String version = "0";
    public String subtitle = "";
    @SerializedName(value="creative_tab")
    public String creativeTab = "misc";
    @SerializedName(value="advancements_tab")
    public ResourceLocation advancementsTab;
    @SerializedName(value="dont_generate_book")
    public boolean noBook = false;
    @SerializedName(value="custom_book_item")
    public String customBookItem = "";
    @SerializedName(value="show_toasts")
    public boolean showToasts = true;
    @SerializedName(value="extend")
    public ResourceLocation extend;
    @SerializedName(value="allow_extensions")
    public boolean allowExtensions = true;
    @SerializedName(value="pause_game")
    public boolean pauseGame = false;
    public boolean i18n = false;
    public Map<String, String> macros = new HashMap<String, String>();

    public void build(IModInfo owner, Class<?> ownerClass, ResourceLocation resource, boolean external) {
        this.owner = owner;
        this.ownerClass = ownerClass;
        this.id = resource;
        this.isExternal = external;
        boolean bl = this.isExtension = this.extend != null;
        if (!this.isExtension) {
            this.textColor = 0xFF000000 | Integer.parseInt(this.textColorRaw, 16);
            this.headerColor = 0xFF000000 | Integer.parseInt(this.headerColorRaw, 16);
            this.nameplateColor = 0xFF000000 | Integer.parseInt(this.nameplateColorRaw, 16);
            this.linkColor = 0xFF000000 | Integer.parseInt(this.linkColorRaw, 16);
            this.linkHoverColor = 0xFF000000 | Integer.parseInt(this.linkHoverColorRaw, 16);
            this.progressBarColor = 0xFF000000 | Integer.parseInt(this.progressBarColorRaw, 16);
            this.progressBarBackground = 0xFF000000 | Integer.parseInt(this.progressBarBackgroundRaw, 16);
            for (String m : DEFAULT_MACROS.keySet()) {
                if (this.macros.containsKey(m)) continue;
                this.macros.put(m, DEFAULT_MACROS.get(m));
            }
        }
    }

    public String getModNamespace() {
        return this.id.func_110624_b();
    }

    public ItemStack getBookItem() {
        if (this.bookItem == null) {
            this.bookItem = this.noBook ? ItemStackUtil.loadStackFromString(this.customBookItem) : ItemModBook.forBook(this);
        }
        return this.bookItem;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void markUpdated() {
        this.wasUpdated = true;
    }

    public boolean popUpdated() {
        boolean updated = this.wasUpdated;
        this.wasUpdated = false;
        return updated;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void reloadContentsAndExtensions() {
        this.reloadContents();
        for (Book b : this.extensions) {
            b.reloadExtensionContents();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void reloadContents() {
        if (this.contents == null) {
            BookContents bookContents = this.contents = this.isExternal ? new ExternalBookContents(this) : new BookContents(this);
        }
        if (!this.isExtension) {
            this.contents.reload(false);
            MinecraftForge.EVENT_BUS.post((Event)new BookContentsReloadEvent(this.id));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void reloadExtensionContents() {
        if (this.isExtension) {
            if (this.extensionTarget == null) {
                this.extensionTarget = BookRegistry.INSTANCE.books.get(this.extend);
                if (this.extensionTarget == null) {
                    throw new IllegalArgumentException("Extension Book " + this.id + " has no valid target");
                }
                if (!this.extensionTarget.allowExtensions) {
                    throw new IllegalArgumentException("Book " + this.extensionTarget.id + " doesn't allow extensions, so " + this.id + " can't resolve");
                }
                this.extensionTarget.extensions.add(this);
                this.contents.categories = this.extensionTarget.contents.categories;
                this.contents.entries = this.extensionTarget.contents.entries;
                this.contents.templates = this.extensionTarget.contents.templates;
                this.contents.recipeMappings = this.extensionTarget.contents.recipeMappings;
            }
            this.contents.reload(true);
            MinecraftForge.EVENT_BUS.post((Event)new BookContentsReloadEvent(this.id));
        }
    }

    public final boolean advancementsEnabled() {
        return (Boolean)PatchouliConfig.disableAdvancementLocking.get() == false && !((List)PatchouliConfig.noAdvancementBooks.get()).contains(this.id.toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void reloadLocks(boolean suppressToasts) {
        this.contents.entries.values().forEach(BookEntry::updateLockStatus);
        this.contents.categories.values().forEach(c -> c.updateLockStatus(true));
        boolean updated = this.popUpdated();
        if (updated && !suppressToasts && this.advancementsEnabled() && this.showToasts) {
            ClientAdvancements.sendBookToast(this);
        }
    }

    public String getOwnerName() {
        return this.owner.getDisplayName();
    }

    @OnlyIn(value=Dist.CLIENT)
    public FontRenderer getFont() {
        if (this.useBlockyFont) {
            return Minecraft.func_71410_x().field_71466_p;
        }
        return Minecraft.func_71410_x().func_211500_ak().func_211504_a(UNICODE_FONT_ID);
    }

    public ITextComponent getSubtitle() {
        TranslationTextComponent editionStr;
        try {
            int ver = Integer.parseInt(this.version);
            if (ver == 0) {
                return new TranslationTextComponent(this.subtitle, new Object[0]);
            }
            editionStr = new StringTextComponent(Book.numberToOrdinal(ver));
        }
        catch (NumberFormatException e) {
            editionStr = new TranslationTextComponent("patchouli.gui.lexicon.dev_edition", new Object[0]);
        }
        return new TranslationTextComponent("patchouli.gui.lexicon.edition_str", new Object[]{editionStr});
    }

    private static String numberToOrdinal(int i) {
        return i % 100 == 11 || i % 100 == 12 || i % 100 == 13 ? i + "th" : i + ORDINAL_SUFFIXES[i % 10];
    }
}

