/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.TriPredicate;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.multiblock.StateMatcher;

public class StringStateMatcher {
    public static IStateMatcher fromString(String s) throws CommandSyntaxException {
        if ((s = s.trim()).equals("ANY")) {
            return StateMatcher.ANY;
        }
        if (s.equals("AIR")) {
            return StateMatcher.AIR;
        }
        BlockStateParser parser = new BlockStateParser(new StringReader(s), true).func_197243_a(false);
        BlockState state = parser.func_197249_b();
        if (state != null) {
            return new ExactMatcher(state, parser.func_197254_a());
        }
        BlockTags.Wrapper tag = new BlockTags.Wrapper(Objects.requireNonNull(parser.func_199829_d()));
        return new TagMatcher((Tag)tag, parser.func_200139_j());
    }

    private static class TagMatcher
    implements IStateMatcher {
        private final Tag<Block> tag;
        private final Map<String, String> props;

        private TagMatcher(Tag<Block> tag, Map<String, String> props) {
            this.tag = tag;
            this.props = props;
        }

        @Override
        public BlockState getDisplayedState(int ticks) {
            ArrayList all = new ArrayList(this.tag.func_199885_a());
            if (all.isEmpty()) {
                return Blocks.field_150357_h.func_176223_P();
            }
            int idx = ticks / 20 % all.size();
            return ((Block)all.get(idx)).func_176223_P();
        }

        @Override
        public TriPredicate<IBlockReader, BlockPos, BlockState> getStatePredicate() {
            return (w, p, s) -> this.tag.func_199685_a_((Object)s.func_177230_c()) && this.checkProps((BlockState)s);
        }

        private boolean checkProps(BlockState state) {
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                IProperty prop = state.func_177230_c().func_176194_O().func_185920_a(entry.getKey());
                if (prop == null) {
                    return false;
                }
                Comparable value = prop.func_185929_b(entry.getValue()).orElse(null);
                if (value == null) {
                    return false;
                }
                if (state.func_177229_b(prop).equals(value)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagMatcher that = (TagMatcher)o;
            return Objects.equals(this.tag.func_199886_b(), that.tag.func_199886_b()) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.tag.func_199886_b(), this.props);
        }
    }

    private static class ExactMatcher
    implements IStateMatcher {
        private final BlockState state;
        private final Map<IProperty<?>, Comparable<?>> props;

        private ExactMatcher(BlockState state, Map<IProperty<?>, Comparable<?>> props) {
            this.state = state;
            this.props = props;
        }

        @Override
        public BlockState getDisplayedState(int ticks) {
            return this.state;
        }

        @Override
        public TriPredicate<IBlockReader, BlockPos, BlockState> getStatePredicate() {
            return (w, p, s) -> this.state.func_177230_c() == s.func_177230_c() && this.checkProps((BlockState)s);
        }

        private boolean checkProps(BlockState state) {
            for (Map.Entry<IProperty<?>, Comparable<?>> e : this.props.entrySet()) {
                if (state.func_177229_b(e.getKey()).equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactMatcher that = (ExactMatcher)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.props);
        }
    }
}

