/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackUtil {
    private static final Gson GSON = new GsonBuilder().create();

    public static String serializeStack(ItemStack stack) {
        StringBuilder builder = new StringBuilder();
        builder.append(stack.func_77973_b().getRegistryName().toString());
        int count = stack.func_190916_E();
        if (count > 1) {
            builder.append("#");
            builder.append(count);
        }
        if (stack.func_77942_o()) {
            Dynamic dyn = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)stack.func_77978_p());
            JsonElement j = (JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue();
            builder.append(GSON.toJson(j));
        }
        return builder.toString();
    }

    public static ItemStack loadStackFromString(String res) {
        String[] tokens;
        String nbt = "";
        int nbtStart = res.indexOf("{");
        if (nbtStart > 0) {
            nbt = res.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            res = res.substring(0, nbtStart);
        }
        String[] upper = res.split("#");
        String count = "1";
        if (upper.length > 1) {
            res = upper[0];
            count = upper[1];
        }
        if ((tokens = res.split(":")).length < 2) {
            return ItemStack.field_190927_a;
        }
        int countn = Integer.parseInt(count);
        ResourceLocation key = new ResourceLocation(tokens[0], tokens[1]);
        if (!ForgeRegistries.ITEMS.containsKey(key)) {
            throw new RuntimeException("Unknown item ID: " + key);
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
        ItemStack stack = new ItemStack((IItemProvider)item, countn);
        if (!nbt.isEmpty()) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)nbt));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException("Failed to parse ItemStack JSON", e);
            }
        }
        return stack;
    }

    public static String serializeIngredient(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.func_193365_a();
        CharSequence[] stacksSerialized = new String[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacksSerialized[i] = ItemStackUtil.serializeStack(stacks[i]);
        }
        return String.join((CharSequence)",", stacksSerialized);
    }

    public static Ingredient loadIngredientFromString(String ingredientString) {
        return Ingredient.func_193369_a((ItemStack[])ItemStackUtil.loadStackListFromString(ingredientString).toArray(new ItemStack[0]));
    }

    public static String serializeStackList(List<ItemStack> stacks) {
        StringJoiner joiner = new StringJoiner(",");
        for (ItemStack stack : stacks) {
            joiner.add(ItemStackUtil.serializeStack(stack));
        }
        return joiner.toString();
    }

    public static List<ItemStack> loadStackListFromString(String ingredientString) {
        String[] stacksSerialized = ItemStackUtil.splitStacksFromSerializedIngredient(ingredientString);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < stacksSerialized.length; ++i) {
            if (stacksSerialized[i].startsWith("tag:")) {
                Tag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(stacksSerialized[i].substring(4)));
                if (tag == null) continue;
                for (Item item : tag.func_199885_a()) {
                    stacks.add(new ItemStack((IItemProvider)item));
                }
                continue;
            }
            stacks.add(ItemStackUtil.loadStackFromString(stacksSerialized[i]));
        }
        return stacks;
    }

    public static StackWrapper wrapStack(ItemStack stack) {
        return stack.func_190926_b() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
    }

    private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int braces = 0;
        Character insideString = null;
        block7: for (int i = 0; i < ingredientSerialized.length(); ++i) {
            switch (ingredientSerialized.charAt(i)) {
                case '{': {
                    if (insideString != null) continue block7;
                    ++braces;
                    continue block7;
                }
                case '}': {
                    if (insideString != null) continue block7;
                    --braces;
                    continue block7;
                }
                case '\'': {
                    insideString = insideString == null ? Character.valueOf('\'') : null;
                    continue block7;
                }
                case '\"': {
                    insideString = insideString == null ? Character.valueOf('\"') : null;
                    continue block7;
                }
                case ',': {
                    if (braces > 0) continue block7;
                    result.add(ingredientSerialized.substring(lastIndex, i));
                    lastIndex = i + 1;
                }
            }
        }
        result.add(ingredientSerialized.substring(lastIndex));
        return result.toArray(new String[0]);
    }

    public static class StackWrapper {
        public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(ItemStack.field_190927_a);
        public final ItemStack stack;

        public StackWrapper(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StackWrapper && ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)((StackWrapper)obj).stack);
        }

        public int hashCode() {
            return this.stack.func_77973_b().hashCode();
        }

        public String toString() {
            return "Wrapper[" + this.stack.toString() + "]";
        }
    }
}

