/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdFluidAccumulator {

    public static class FluidAccumulatorTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    ICapabilityProvider {
        protected static int tick_idle_interval = 20;
        protected static int max_flowrate = 1000;
        private Direction block_facing_ = Direction.NORTH;
        private FluidStack tank_ = FluidStack.EMPTY;
        private int last_drain_request_amount_ = 0;
        private int vacuum_ = 0;
        private int tick_timer_ = 0;
        private int round_robin_ = 0;
        private boolean initialized_ = false;
        private int total_volume_filled_ = 0;
        private int total_volume_drained_ = 0;
        private final LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new OutputFlowHandler(this));
        private final LazyOptional<IFluidHandler> fill_handler_ = LazyOptional.of(() -> new InputFillHandler(this));

        public void send_device_stats(PlayerEntity player) {
            int t_vol = this.tank_.getAmount();
            Auxiliaries.playerChatMessage(player, "" + t_vol + "mB");
        }

        public void block_changed() {
            this.initialized_ = false;
            this.tick_timer_ = MathHelper.func_76125_a((int)this.tick_timer_, (int)0, (int)tick_idle_interval);
        }

        public FluidAccumulatorTileEntity() {
            this(ModContent.TET_PASSIVE_FLUID_ACCUMULATOR);
        }

        public FluidAccumulatorTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.tank_ = !nbt.func_74764_b("tank") ? FluidStack.EMPTY : FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("tank"));
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            if (!this.tank_.isEmpty()) {
                nbt.func_218657_a("tank", (INBT)this.tank_.writeToNBT(new CompoundNBT()));
            }
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.fill_handler_.invalidate();
            this.fluid_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                if (this.initialized_) {
                    if (facing == this.block_facing_) {
                        return this.fluid_handler_.cast();
                    }
                    if (facing != null) {
                        return this.fill_handler_.cast();
                    }
                }
                return LazyOptional.empty();
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = tick_idle_interval;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof FluidAccumulatorBlock)) {
                return;
            }
            if (!this.initialized_) {
                this.initialized_ = true;
                this.block_facing_ = (Direction)state.func_177229_b((IProperty)FluidAccumulatorBlock.FACING);
            }
            int n_requested = this.last_drain_request_amount_;
            this.last_drain_request_amount_ = 0;
            if (n_requested > 0) {
                this.vacuum_ += 2;
                if (this.vacuum_ > 5) {
                    this.vacuum_ = 5;
                }
            } else if (--this.vacuum_ <= 0) {
                this.vacuum_ = 0;
                if (!this.tank_.isEmpty()) {
                    return;
                }
                n_requested = 10;
            }
            boolean has_refilled = false;
            int tank_buffer_needed = n_requested += this.vacuum_ * 50;
            if (tank_buffer_needed > max_flowrate) {
                tank_buffer_needed = max_flowrate;
            }
            for (int i = 0; i < 6; ++i) {
                IFluidHandler fh;
                TileEntity te;
                if (++this.round_robin_ > 5) {
                    this.round_robin_ = 0;
                }
                if (n_requested <= 0 || this.tank_.getAmount() >= tank_buffer_needed) break;
                Direction f = Direction.func_82600_a((int)this.round_robin_);
                if (f == this.block_facing_ || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f))) == null || te instanceof FluidAccumulatorTileEntity || (fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d()).orElse(null)) == null) continue;
                if (this.tank_.isEmpty()) {
                    FluidStack res = fh.drain(n_requested, IFluidHandler.FluidAction.EXECUTE).copy();
                    if (res.isEmpty()) continue;
                    this.total_volume_filled_ += res.getAmount();
                    this.tank_ = res.copy();
                    has_refilled = true;
                    continue;
                }
                if (this.tank_.getAmount() + n_requested > max_flowrate) {
                    n_requested = max_flowrate - this.tank_.getAmount();
                }
                FluidStack rq = this.tank_.copy();
                rq.setAmount(n_requested);
                FluidStack res = fh.drain(rq, IFluidHandler.FluidAction.SIMULATE);
                if (!res.isFluidEqual(rq) || (res = fh.drain(rq, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
                this.tank_.setAmount(this.tank_.getAmount() + res.getAmount());
                this.total_volume_filled_ += res.getAmount();
                has_refilled = true;
                if (this.tank_.getAmount() >= max_flowrate) break;
            }
            if (has_refilled) {
                this.tick_timer_ = 0;
            }
        }

        private static class OutputFlowHandler
        implements IFluidHandler {
            private final FluidAccumulatorTileEntity te;

            OutputFlowHandler(FluidAccumulatorTileEntity parent) {
                this.te = parent;
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return this.te.tank_.copy();
            }

            public int getTankCapacity(int tank) {
                return max_flowrate;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return true;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource == null || this.te.tank_.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                return !this.te.tank_.isFluidEqual(resource) ? FluidStack.EMPTY : this.drain(resource.getAmount(), action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (!this.te.initialized_) {
                    return FluidStack.EMPTY;
                }
                if (action == IFluidHandler.FluidAction.EXECUTE && maxDrain > 0) {
                    this.te.last_drain_request_amount_ = maxDrain;
                }
                if (this.te.tank_.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                maxDrain = MathHelper.func_76125_a((int)maxDrain, (int)0, (int)this.te.tank_.getAmount());
                FluidStack res = this.te.tank_.copy();
                if (action != IFluidHandler.FluidAction.EXECUTE) {
                    return res;
                }
                res.setAmount(maxDrain);
                this.te.tank_.setAmount(this.te.tank_.getAmount() - maxDrain);
                if (this.te.tank_.getAmount() <= 0) {
                    this.te.tank_ = FluidStack.EMPTY;
                }
                FluidAccumulatorTileEntity fluidAccumulatorTileEntity = this.te;
                fluidAccumulatorTileEntity.total_volume_drained_ = fluidAccumulatorTileEntity.total_volume_drained_ + res.getAmount();
                return res;
            }
        }

        private static class InputFillHandler
        implements IFluidHandler {
            private final FluidAccumulatorTileEntity parent_;

            InputFillHandler(FluidAccumulatorTileEntity parent) {
                this.parent_ = parent;
            }

            public int getTanks() {
                return 0;
            }

            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return max_flowrate;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return true;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        }
    }

    public static class FluidAccumulatorBlock
    extends DecorBlock.Directed
    implements IDecorBlock {
        public FluidAccumulatorBlock(long config, Block.Properties builder, AxisAlignedBB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new FluidAccumulatorTileEntity();
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FluidAccumulatorTileEntity)) {
                return ActionResultType.FAIL;
            }
            ((FluidAccumulatorTileEntity)te).send_device_stats(player);
            return ActionResultType.SUCCESS;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof FluidAccumulatorTileEntity) {
                ((FluidAccumulatorTileEntity)te).block_changed();
            }
        }
    }
}

