/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.block;

import com.davenonymous.bonsaitrees2.block.BonsaiPotTileEntity;
import com.davenonymous.bonsaitrees2.render.TreeModels;
import com.davenonymous.libnonymous.render.MultiblockBlockModel;
import com.davenonymous.libnonymous.render.MultiblockBlockModelRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class BonsaiPotTileEntityRenderer
extends TileEntityRenderer<BonsaiPotTileEntity> {
    private static boolean clearLists = false;
    private static final Random rand = new Random();
    private static Map<MultiblockBlockModel, Integer> glLists = new HashMap<MultiblockBlockModel, Integer>();

    public BonsaiPotTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static void clearGlLists() {
        clearLists = true;
    }

    public void render(BonsaiPotTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderSoil(tileEntityIn, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderShape(tileEntityIn, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderShape(BonsaiPotTileEntity tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.hasSapling()) {
            return;
        }
        MultiblockBlockModel model = TreeModels.get(tile.getTreeId());
        if (model == null) {
            return;
        }
        if (model.getBlockCount() == 0) {
            return;
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.0, 0.5);
        matrix.func_227861_a_(0.0, 0.1, 0.0);
        float scale = (float)model.getScaleRatio(false);
        matrix.func_227862_a_(scale, scale, scale);
        float maxSize = 0.9f;
        matrix.func_227862_a_(maxSize, maxSize, maxSize);
        float progress = (float)tile.getProgress(partialTicks);
        matrix.func_227862_a_(progress, progress, progress);
        float rotate = (float)tile.modelRotation * 90.0f;
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotate));
        float translateOffsetX = (float)(model.width + 1) / 2.0f;
        float translateOffsetY = 0.0f;
        float translateOffsetZ = (float)(model.depth + 1) / 2.0f;
        matrix.func_227861_a_((double)(-translateOffsetX), (double)(-translateOffsetY), (double)(-translateOffsetZ));
        MultiblockBlockModelRenderer.renderModel((MultiblockBlockModel)model, (MatrixStack)matrix, (IRenderTypeBuffer)buffer, (int)combinedLightIn, (int)combinedOverlayIn, (IWorldReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v());
        matrix.func_227865_b_();
    }

    private void renderSoil(BonsaiPotTileEntity tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tile.getSoilBlockState() == null) {
            return;
        }
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        matrix.func_227861_a_(2.0, 1.1, 2.0);
        matrix.func_227862_a_(12.0f, 1.0f, 12.0f);
        brd.renderModel(tile.getSoilBlockState(), tile.func_174877_v(), (ILightReader)tile.func_145831_w(), matrix, buffer.getBuffer(RenderType.func_228641_d_()), false, tile.func_145831_w().field_73012_v, (IModelData)EmptyModelData.INSTANCE);
        matrix.func_227865_b_();
    }
}

