/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.gui.widgets;

import com.davenonymous.bonsaitrees2.gui.TreeCreatorScreen;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingInfo;
import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.util.FontAwesomeIcons;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetButton;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetCheckbox;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetFontAwesome;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetTextBox;
import com.davenonymous.libnonymous.render.MultiblockBlockModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SavePanel
extends WidgetPanel {
    MultiblockBlockModel model;
    WidgetTextBox statusBox;
    WidgetCheckbox overwriteFiles;

    public SavePanel(int width, int height, MultiblockBlockModel model) {
        this.setSize(width, height);
        this.model = model;
        WidgetButton saveToDiskButton = new WidgetButton(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.button.save_to_disk", (Object[])new Object[0]));
        saveToDiskButton.addListener(MouseClickEvent.class, (event, widget) -> {
            this.saveToDisk();
            return WidgetEventResult.HANDLED;
        });
        this.add((Widget)saveToDiskButton);
        this.statusBox = new WidgetTextBox("", -16744448);
        this.statusBox.setDimensions(5, 45, width - 10, 30);
        this.add((Widget)this.statusBox);
        this.overwriteFiles = new WidgetCheckbox();
        this.overwriteFiles.setValue((Object)false);
        this.overwriteFiles.setPosition(0, 24);
        this.add((Widget)this.overwriteFiles);
        WidgetTextBox overwriteFilesLabel = new WidgetTextBox(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.checkbox.overwrite_files", (Object[])new Object[0]), -1073741824);
        overwriteFilesLabel.setPosition(12, 25);
        this.add((Widget)overwriteFilesLabel);
        WidgetTextBox openloaderHint = new WidgetTextBox(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.hint.openloader", (Object[])new Object[0]), -1879048192);
        openloaderHint.setDimensions(0, 80, width - 10, height - 85 - 34);
        this.add((Widget)openloaderHint);
        String openLoaderUrl = "https://www.curseforge.com/minecraft/mc-mods/open-loader";
        WidgetButton openOpenLoaderPage = new WidgetButton(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.button.go_to_openloader", (Object[])new Object[0]));
        openOpenLoaderPage.setTooltipLines(new ITextComponent[]{new StringTextComponent("https://www.curseforge.com/minecraft/mc-mods/open-loader")});
        openOpenLoaderPage.setDimensions(width - 10 - 120, height - 34, 120, 24);
        openOpenLoaderPage.addListener(MouseClickEvent.class, (event, widget) -> {
            Util.func_110647_a().func_195640_a("https://www.curseforge.com/minecraft/mc-mods/open-loader");
            return WidgetEventResult.HANDLED;
        });
        this.add((Widget)openOpenLoaderPage);
        WidgetFontAwesome externalIcon = new WidgetFontAwesome(FontAwesomeIcons.SOLID_ExternalLinkAlt, WidgetFontAwesome.IconSize.MEDIUM);
        externalIcon.setPosition(width - 10 - 120 + 4, height - 34 + 3);
        this.add((Widget)externalIcon);
    }

    private void saveToDisk() {
        GUI gui = this.getGUI();
        String treeIdString = (String)gui.getValue(TreeCreatorScreen.STATE_TREE_ID);
        String treeIdPath = treeIdString.replaceAll(":", "/");
        ResourceLocation treeId = ResourceLocation.func_208304_a((String)treeIdString);
        int baseTicks = (Integer)gui.getValue(TreeCreatorScreen.STATE_BASETICKS);
        String tags = (String)gui.getValue(TreeCreatorScreen.STATE_TAGS);
        ItemStack sapling = (ItemStack)gui.getValue(TreeCreatorScreen.STATE_SAPLING);
        List drops = (List)gui.getValue(TreeCreatorScreen.STATE_DROPS);
        if (treeIdString.length() == 0) {
            this.statusBox.setText(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.warning.missing_tree_id", (Object[])new Object[0]));
            return;
        }
        if (this.model.blocks.size() >= 4095) {
            this.statusBox.setText(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.warning.too_many_blocks", (Object[])new Object[0]));
            return;
        }
        if (this.model.refMap.size() > 26) {
            this.statusBox.setText(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.warning.too_many_types", (Object[])new Object[0]));
            return;
        }
        File assetPath = new File(Minecraft.func_71410_x().field_71412_D, "openloader/resources/custombonsais/assets/bonsaitrees2/models/tree/" + treeId.func_110624_b());
        assetPath.mkdirs();
        File recipePath = new File(Minecraft.func_71410_x().field_71412_D, "openloader/data/custombonsais/data/bonsaitrees2/recipes/sapling/" + treeId.func_110624_b());
        recipePath.mkdirs();
        File datapackMetaFile = new File(Minecraft.func_71410_x().field_71412_D, "openloader/data/custombonsais/pack.mcmeta");
        File resourcepackMetaFile = new File(Minecraft.func_71410_x().field_71412_D, "openloader/resources/custombonsais/pack.mcmeta");
        String metaData = "{\"pack\":{\"description\":\"Additional Bonsai Trees\",\"pack_format\": 5}}";
        if (!datapackMetaFile.exists()) {
            this.saveStringToFile(datapackMetaFile, "{\"pack\":{\"description\":\"Additional Bonsai Trees\",\"pack_format\": 5}}");
        }
        if (!resourcepackMetaFile.exists()) {
            this.saveStringToFile(resourcepackMetaFile, "{\"pack\":{\"description\":\"Additional Bonsai Trees\",\"pack_format\": 5}}");
        }
        File modelPath = new File(assetPath, treeId.func_110623_a() + ".json");
        File recipeFilePath = new File(recipePath, treeId.func_110623_a() + ".json");
        if ((recipeFilePath.exists() || modelPath.exists()) && !((Boolean)this.overwriteFiles.getValue()).booleanValue()) {
            this.statusBox.setText(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.warning.files_already_exists", (Object[])new Object[0]));
            return;
        }
        this.model.id = new ResourceLocation("bonsaitrees2", "sapling/" + treeIdPath);
        SaplingInfo saplingInfo = new SaplingInfo(this.model.id, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{sapling}), baseTicks);
        saplingInfo.sapling = sapling.func_77946_l();
        drops.stream().forEach(saplingInfo::addDrop);
        for (String tag : tags.split(",")) {
            saplingInfo.addTag(tag);
        }
        this.saveStringToFile(modelPath, this.model.serializePretty());
        this.saveStringToFile(recipeFilePath, saplingInfo.serializePretty());
        this.statusBox.setText(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.label.saved_files", (Object[])new Object[0]));
    }

    private void saveStringToFile(File file, String string) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            writer.write(string);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

