/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.registry.sapling;

import com.davenonymous.bonsaitrees2.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees2.util.Logz;
import com.davenonymous.libnonymous.utils.MCJsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SaplingSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<SaplingInfo> {
    private Marker mark = MarkerManager.getMarker((String)"Serializer");

    public SaplingSerializer() {
        this.setRegistryName(new ResourceLocation("bonsaitrees2", "sapling"));
    }

    private boolean isValidIngredient(JsonObject obj) {
        if (obj == null) {
            return false;
        }
        Item item = MCJsonUtils.getItem((JsonObject)obj, (String)"item");
        return !item.getRegistryName().toString().equals("minecraft:air");
    }

    public SaplingInfo read(ResourceLocation recipeId, JsonObject json) {
        if (!this.isValidIngredient(json.getAsJsonObject("sapling"))) {
            Logz.info(this.mark, "Skipping recipe '{}', contains unknown sapling.", recipeId);
            return null;
        }
        Ingredient sapling = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("sapling"));
        int baseTicks = 200;
        if (json.has("ticks")) {
            baseTicks = json.get("ticks").getAsInt();
        }
        SaplingInfo result = new SaplingInfo(recipeId, sapling, baseTicks);
        if (json.has("drops")) {
            JsonArray dropsJson = json.getAsJsonArray("drops");
            for (JsonElement element : dropsJson) {
                if (!element.isJsonObject()) continue;
                JsonObject dropObj = element.getAsJsonObject();
                if (!this.isValidIngredient(dropObj.getAsJsonObject("result"))) {
                    Logz.info(this.mark, "Skipping recipe '{}', contains unknown drop.", recipeId);
                    return null;
                }
                SaplingDrop drop = new SaplingDrop(element.getAsJsonObject());
                if (drop == null) continue;
                result.addDrop(drop);
            }
        }
        if (json.has("compatibleSoilTags")) {
            JsonArray tagsJson = json.getAsJsonArray("compatibleSoilTags");
            for (JsonElement element : tagsJson) {
                String tag;
                if (!element.isJsonPrimitive() || (tag = element.getAsString()) == null) continue;
                result.addTag(tag);
            }
        }
        return result;
    }

    @Nullable
    public SaplingInfo read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        int baseTicks = buffer.readInt();
        SaplingInfo result = new SaplingInfo(recipeId, ingredient, baseTicks);
        int dropCount = buffer.readInt();
        for (int i = 0; i < dropCount; ++i) {
            result.addDrop(new SaplingDrop(buffer));
        }
        int tagCount = buffer.readInt();
        for (int i = 0; i < tagCount; ++i) {
            result.addTag(buffer.func_218666_n());
        }
        return result;
    }

    public void write(PacketBuffer buffer, SaplingInfo sapling) {
        sapling.ingredient.func_199564_a(buffer);
        buffer.writeInt(sapling.baseTicks);
        buffer.writeInt(sapling.drops.size());
        for (SaplingDrop drop : sapling.drops) {
            drop.write(buffer);
        }
        buffer.writeInt(sapling.tags.size());
        for (String tag : sapling.tags) {
            buffer.func_180714_a(tag);
        }
    }
}

