/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.registry.soil;

import com.davenonymous.bonsaitrees2.registry.soil.SoilInfo;
import com.davenonymous.libnonymous.utils.BlockStateSerializationHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoilSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<SoilInfo> {
    public SoilSerializer() {
        this.setRegistryName(new ResourceLocation("bonsaitrees2", "soil"));
    }

    public SoilInfo read(ResourceLocation recipeId, JsonObject json) {
        Ingredient soil = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("soil"));
        BlockState renderState = BlockStateSerializationHelper.deserializeBlockState((JsonObject)json.getAsJsonObject("display"));
        float tickModifier = 1.0f;
        if (json.has("tickModifier")) {
            tickModifier = json.get("tickModifier").getAsFloat();
        }
        SoilInfo result = new SoilInfo(recipeId, soil, renderState, tickModifier);
        if (json.has("compatibleSoilTags")) {
            JsonArray tagsJson = json.getAsJsonArray("compatibleSoilTags");
            for (JsonElement element : tagsJson) {
                String tag;
                if (!element.isJsonPrimitive() || (tag = element.getAsString()) == null) continue;
                result.addTag(tag);
            }
        }
        return result;
    }

    @Nullable
    public SoilInfo read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        BlockState renderState = BlockStateSerializationHelper.deserializeBlockState((PacketBuffer)buffer);
        float tickModifier = buffer.readFloat();
        SoilInfo result = new SoilInfo(recipeId, ingredient, renderState, tickModifier);
        int tagCount = buffer.readInt();
        for (int i = 0; i < tagCount; ++i) {
            result.addTag(buffer.func_218666_n());
        }
        return result;
    }

    public void write(PacketBuffer buffer, SoilInfo soil) {
        soil.ingredient.func_199564_a(buffer);
        BlockStateSerializationHelper.serializeBlockState((PacketBuffer)buffer, (BlockState)soil.renderState);
        buffer.writeFloat(soil.tickModifier);
        buffer.writeInt(soil.tags.size());
        for (String tag : soil.tags) {
            buffer.func_180714_a(tag);
        }
    }
}

