/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.GasStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class FluidGasToGasRecipe
extends MekanismRecipe
implements BiPredicate<FluidStack, GasStack> {
    private final GasStackIngredient gasInput;
    private final FluidStackIngredient fluidInput;
    private final GasStack output;

    public FluidGasToGasRecipe(ResourceLocation id, FluidStackIngredient fluidInput, GasStackIngredient gasInput, GasStack output) {
        super(id);
        this.fluidInput = fluidInput;
        this.gasInput = gasInput;
        this.output = output;
    }

    @Override
    public boolean test(FluidStack fluidStack, GasStack gasStack) {
        return this.fluidInput.test(fluidStack) && this.gasInput.test(gasStack);
    }

    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    public GasStackIngredient getGasInput() {
        return this.gasInput;
    }

    public GasStack getOutputRepresentation() {
        return this.output;
    }

    @Contract(value="_, _ -> new", pure=true)
    public GasStack getOutput(FluidStack fluidStack, GasStack input) {
        return this.output.copy();
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.fluidInput.write(buffer);
        this.gasInput.write(buffer);
        this.output.writeToPacket(buffer);
    }
}

