/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class GasToGasCachedRecipe
extends CachedRecipe<GasToGasRecipe> {
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull GasStack> inputHandler;

    public GasToGasCachedRecipe(GasToGasRecipe recipe, IInputHandler<@NonNull GasStack> inputHandler, IOutputHandler<@NonNull GasStack> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        GasStack recipeInput = this.inputHandler.getRecipeInput(((GasToGasRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((GasToGasRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((GasToGasRecipe)this.recipe).getOutput(recipeInput), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((GasToGasRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        GasStack recipeInput = this.inputHandler.getRecipeInput(((GasToGasRecipe)this.recipe).getInput());
        if (recipeInput.isEmpty()) {
            return;
        }
        this.inputHandler.use(recipeInput, operations);
        this.outputHandler.handleOutput(((GasToGasRecipe)this.recipe).getOutput(recipeInput), operations);
    }
}

