/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;

public interface ICachedRecipeHolder<RECIPE extends MekanismRecipe> {
    @Nullable
    default public CachedRecipe<RECIPE> getUpdatedCache(int cacheIndex) {
        RECIPE recipe;
        CachedRecipe<RECIPE> currentCache = this.getCachedRecipe(cacheIndex);
        if (!(currentCache != null && currentCache.isInputValid() || (recipe = this.getRecipe(cacheIndex)) == null)) {
            CachedRecipe<RECIPE> cached = this.createNewCachedRecipe(recipe, cacheIndex);
            if (currentCache == null || cached != null) {
                if (currentCache == null && cached != null) {
                    cached.loadSavedOperatingTicks(this.getSavedOperatingTicks(cacheIndex));
                }
                return cached;
            }
        }
        return currentCache;
    }

    default public int getSavedOperatingTicks(int cacheIndex) {
        return 0;
    }

    @Nullable
    public CachedRecipe<RECIPE> getCachedRecipe(int var1);

    @Nullable
    public RECIPE getRecipe(int var1);

    @Nullable
    public CachedRecipe<RECIPE> createNewCachedRecipe(@Nonnull RECIPE var1, int var2);
}

