/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.function.LongSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackGasToItemStackCachedRecipe
extends CachedRecipe<ItemStackGasToItemStackRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private final LongSupplier gasUsage;

    public ItemStackGasToItemStackCachedRecipe(ItemStackGasToItemStackRecipe recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, ILongInputHandler<@NonNull GasStack> gasInputHandler, LongSupplier gasUsage, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.itemInputHandler = itemInputHandler;
        this.gasInputHandler = gasInputHandler;
        this.gasUsage = gasUsage;
        this.outputHandler = outputHandler;
    }

    private long getGasUsage() {
        return this.gasUsage.getAsLong();
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ItemStackGasToItemStackRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ItemStackGasToItemStackRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return 0;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(((ItemStackGasToItemStackRecipe)this.recipe).getItemInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        currentMax = this.gasInputHandler.operationsCanSupport((InputIngredient<GasStack>)((ItemStackGasToItemStackRecipe)this.recipe).getGasInput(), currentMax, this.getGasUsage());
        return this.outputHandler.operationsRoomFor(((ItemStackGasToItemStackRecipe)this.recipe).getOutput(recipeItem, recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        GasStack gas = (GasStack)this.gasInputHandler.getInput();
        if (!gas.isEmpty() && ((ItemStackGasToItemStackRecipe)this.recipe).test(this.itemInputHandler.getInput(), gas)) {
            GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ItemStackGasToItemStackRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gas.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    @Override
    protected void useResources(int operations) {
        super.useResources(operations);
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ItemStackGasToItemStackRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.gasInputHandler.use(recipeGas, (long)operations * this.getGasUsage());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ItemStackGasToItemStackRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ItemStackGasToItemStackRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.itemInputHandler.use(recipeItem, operations);
        this.gasInputHandler.use(recipeGas, operations);
        this.outputHandler.handleOutput(((ItemStackGasToItemStackRecipe)this.recipe).getOutput(recipeItem, recipeGas), operations);
    }
}

