/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.concurrent.ThreadLocalRandom;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.util.MekanismUtils;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SparkleAnimation {
    private TileEntity tile;
    private BlockPos corner1;
    private BlockPos corner2;
    private INodeChecker nodeChecker;

    public SparkleAnimation(TileEntity tile, BlockPos corner1, BlockPos corner2, INodeChecker checker) {
        this.tile = tile;
        this.corner1 = corner1;
        this.corner2 = corner2;
        this.nodeChecker = checker;
    }

    public SparkleAnimation(TileEntity tile, BlockPos renderLoc, int length, int width, int height, INodeChecker checker) {
        this(tile, new BlockPos(renderLoc.func_177958_n(), renderLoc.func_177956_o() - 1, renderLoc.func_177952_p()), new BlockPos(renderLoc.func_177958_n() + length, renderLoc.func_177956_o() + height - 2, renderLoc.func_177952_p() + width - 1), checker);
    }

    public void run() {
        if (MekanismConfig.client.dynamicTankEasterEgg.get()) {
            this.tile.func_145831_w().func_184148_a(null, (double)this.tile.func_174877_v().func_177958_n(), (double)this.tile.func_174877_v().func_177956_o(), (double)this.tile.func_174877_v().func_177952_p(), MekanismSounds.CJ_EASTER_EGG.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        World world = this.tile.func_145831_w();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.corner1, (BlockPos)this.corner2)) {
            TileEntity t = MekanismUtils.getTileEntity((IBlockReader)world, pos);
            if (t == null || !this.nodeChecker.isNode(t)) continue;
            for (int i = 0; i < 2; ++i) {
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + -0.01, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + 1.01, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + -0.01, (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 1.01, (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static interface INodeChecker {
        public boolean isNode(TileEntity var1);
    }
}

