/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.base.ILangEntry;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiMekanism<CONTAINER extends Container>
extends ContainerScreen<CONTAINER>
implements IGuiWrapper {
    private static final ResourceLocation BASE_BACKGROUND = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "base.png");
    protected boolean dynamicSlots;

    protected GuiMekanism(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    public void init() {
        super.init();
        this.initPreSlots();
        if (this.dynamicSlots) {
            this.addSlots();
        }
    }

    protected void initPreSlots() {
    }

    protected GuiElement.IHoverable getOnHover(ILangEntry translationHelper) {
        return this.getOnHover(() -> translationHelper.translate(new Object[0]));
    }

    protected GuiElement.IHoverable getOnHover(Supplier<ITextComponent> componentSupplier) {
        return (onHover, xAxis, yAxis) -> this.displayTooltip((ITextComponent)componentSupplier.get(), xAxis, yAxis);
    }

    protected ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    public int getStringWidth(ITextComponent component) {
        return this.getStringWidth(component.func_150254_d());
    }

    public int getStringWidth(String text) {
        return this.font.func_78256_a(text);
    }

    public int drawString(ITextComponent component, int x, int y, int color) {
        return this.drawString(component.func_150254_d(), x, y, color);
    }

    public int drawString(String text, int x, int y, int color) {
        return this.font.func_211126_b(text, (float)x, (float)y, color);
    }

    protected void drawCenteredText(ITextComponent component, int leftMargin, int y, int color) {
        this.drawCenteredText(component, leftMargin, 0, y, color);
    }

    protected void drawCenteredText(ITextComponent component, int leftMargin, int areaWidth, int y, int color) {
        int textWidth = this.getStringWidth(component);
        int centerX = leftMargin + areaWidth / 2 - textWidth / 2;
        this.drawString(component, centerX, y, color);
    }

    public void renderScaledText(ITextComponent component, int x, int y, int color, int maxX) {
        this.renderScaledText(component.func_150254_d(), x, y, color, maxX);
    }

    public void renderScaledText(String text, int x, int y, int color, int maxX) {
        int length = this.getStringWidth(text);
        if (length <= maxX) {
            this.drawString(text, x, y, color);
        } else {
            float scale = (float)maxX / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            this.drawString(text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            RenderSystem.popMatrix();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - this.getGuiLeft();
        int yAxis = mouseY - this.getGuiTop();
        for (Widget widget : this.buttons) {
            if (!(widget instanceof GuiElement)) continue;
            ((GuiElement)widget).renderForeground(mouseX, mouseY, xAxis, yAxis);
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseXOld, double mouseYOld) {
        super.mouseDragged(mouseX, mouseY, button, mouseXOld, mouseYOld);
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, mouseXOld, mouseYOld);
    }

    protected boolean isMouseOverSlot(Slot slot, double mouseX, double mouseY) {
        return this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    private void addSlots() {
        int size = this.field_147002_h.field_75151_b.size();
        for (int i = 0; i < size; ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (slot instanceof InventoryContainerSlot) {
                SlotType type;
                InventoryContainerSlot containerSlot = (InventoryContainerSlot)slot;
                ContainerSlotType slotType = containerSlot.getSlotType();
                if (slotType == ContainerSlotType.INPUT) {
                    type = SlotType.INPUT;
                } else if (slotType == ContainerSlotType.OUTPUT) {
                    type = SlotType.OUTPUT;
                } else if (slotType == ContainerSlotType.POWER) {
                    type = SlotType.POWER;
                } else if (slotType == ContainerSlotType.EXTRA) {
                    type = SlotType.EXTRA;
                } else {
                    if (slotType != ContainerSlotType.NORMAL && slotType != ContainerSlotType.VALIDITY) continue;
                    type = SlotType.NORMAL;
                }
                GuiSlot guiSlot = new GuiSlot(type, this, slot.field_75223_e - 1, slot.field_75221_f - 1);
                SlotOverlay slotOverlay = containerSlot.getSlotOverlay();
                if (slotOverlay != null) {
                    guiSlot.with(slotOverlay);
                }
                if (slotType == ContainerSlotType.VALIDITY) {
                    int index = i;
                    guiSlot.validity(() -> this.checkValidity(index));
                }
                this.addButton(guiSlot);
                continue;
            }
            this.addButton(new GuiSlot(SlotType.NORMAL, this, slot.field_75223_e - 1, slot.field_75221_f - 1));
        }
    }

    protected ItemStack checkValidity(int slotIndex) {
        return ItemStack.field_190927_a;
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        MekanismRenderer.resetColor();
        if (this.width < 8 || this.height < 8) {
            Mekanism.logger.warn("Gui: {}, was too small to draw the background of. Unable to draw a background for a gui smaller than 8 by 8.", (Object)this.getClass().getSimpleName());
            return;
        }
        GuiUtils.renderExtendedTexture(BASE_BACKGROUND, 4, 4, this.getGuiLeft(), this.getGuiTop(), this.getXSize(), this.getYSize());
    }

    @Override
    public FontRenderer getFont() {
        return this.font;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Override
    public void renderItem(@Nonnull ItemStack stack, int xAxis, int yAxis, float scale) {
        if (!stack.func_190926_b()) {
            try {
                RenderSystem.pushMatrix();
                RenderSystem.enableDepthTest();
                RenderHelper.func_227780_a_();
                if (scale != 1.0f) {
                    RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                }
                this.itemRenderer.func_180450_b(stack, xAxis, yAxis);
                RenderHelper.func_74518_a();
                RenderSystem.disableDepthTest();
                RenderSystem.popMatrix();
            }
            catch (Exception e) {
                Mekanism.logger.error("Failed to render stack into gui: " + stack, (Throwable)e);
            }
        }
    }
}

