/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Set;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiMekanismTile<TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>>
extends GuiMekanism<CONTAINER> {
    protected final TILE tile;

    protected GuiMekanismTile(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.tile = ((MekanismTileContainer)((Object)container)).getTileEntity();
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        ItemStack stack;
        super.func_146979_b(mouseX, mouseY);
        if (this.tile instanceof ISideConfiguration && !(stack = this.minecraft.field_71439_g.field_71071_by.func_70445_o()).func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator) {
            for (int i = 0; i < ((MekanismTileContainer)this.field_147002_h).field_75151_b.size(); ++i) {
                Slot slot = (Slot)((MekanismTileContainer)this.field_147002_h).field_75151_b.get(i);
                if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                DataType data = this.getFromSlot(slot);
                if (data == null) break;
                this.displayTooltip(MekanismLang.GENERIC_PARENTHESIS.translateColored(data.getColor(), data.getColor().getName()), mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
                break;
            }
        }
    }

    private DataType getFromSlot(Slot slot) {
        ISideConfiguration config;
        ConfigInfo info;
        if (slot.field_75222_d < this.tile.getSlots() && slot instanceof InventoryContainerSlot && (info = (config = (ISideConfiguration)this.tile).getConfig().getConfig(TransmissionType.ITEM)) != null) {
            Set<DataType> supportedDataTypes = info.getSupportedDataTypes();
            IInventorySlot inventorySlot = ((InventoryContainerSlot)slot).getInventorySlot();
            for (DataType type : supportedDataTypes) {
                ISlotInfo slotInfo = info.getSlotInfo(type);
                if (!(slotInfo instanceof InventorySlotInfo) || !((InventorySlotInfo)slotInfo).hasSlot(inventorySlot)) continue;
                return type;
            }
        }
        return null;
    }
}

