/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.text.EnumColor;
import mekanism.client.ClientTickHandler;
import mekanism.client.MekanismClient;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTeleporterStatus;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.item.PortableTeleporterContainer;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.PacketPortableTeleporterGui;
import mekanism.common.security.IOwnerItem;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPortableTeleporter
extends GuiMekanism<PortableTeleporterContainer> {
    private final Hand currentHand;
    private final ItemStack itemStack;
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton setButton;
    private MekanismButton deleteButton;
    private MekanismButton teleportButton;
    private GuiTextScrollList scrollList;
    private TextFieldWidget frequencyField;
    private boolean privateMode;
    private Frequency clientFreq;
    private byte clientStatus;
    private List<Frequency> clientPublicCache = new ArrayList<Frequency>();
    private List<Frequency> clientPrivateCache = new ArrayList<Frequency>();
    private boolean isInit = true;

    public GuiPortableTeleporter(PortableTeleporterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.currentHand = container.getHand();
        this.itemStack = container.getStack();
        this.field_147000_g = 175;
        ItemPortableTeleporter item = (ItemPortableTeleporter)this.itemStack.func_77973_b();
        if (item.getFrequency(this.itemStack) != null) {
            this.privateMode = !item.getFrequency((ItemStack)this.itemStack).publicFreq;
            this.setFrequency(item.getFrequency((ItemStack)this.itemStack).name);
        } else {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, this.clientFreq));
        }
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 48, 102, 89, 13));
        this.addButton(new GuiInnerScreen(this, 136, 102, 13, 13));
        this.addButton(new GuiTeleporterStatus(this, () -> this.clientFreq != null, () -> this.clientStatus));
        this.addButton(new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                IEnergyContainer container = StorageUtils.getEnergyContainer(GuiPortableTeleporter.this.itemStack, 0);
                return container == null ? EnergyDisplay.ZERO.getTextComponent() : EnergyDisplay.of(container.getEnergy(), container.getMaxEnergy()).getTextComponent();
            }

            @Override
            public double getLevel() {
                IEnergyContainer container = StorageUtils.getEnergyContainer(GuiPortableTeleporter.this.itemStack, 0);
                if (container == null) {
                    return 0.0;
                }
                return container.getEnergy().divideToLevel(container.getMaxEnergy());
            }
        }, 158, 26));
        this.scrollList = new GuiTextScrollList(this, 27, 36, 122, 42);
        this.addButton(this.scrollList);
        this.publicButton = new TranslationButton(this, this.getGuiLeft() + 27, this.getGuiTop() + 14, 60, 20, MekanismLang.PUBLIC, () -> {
            this.privateMode = false;
            this.updateButtons();
        });
        this.addButton(this.publicButton);
        this.privateButton = new TranslationButton(this, this.getGuiLeft() + 89, this.getGuiTop() + 14, 60, 20, MekanismLang.PRIVATE, () -> {
            this.privateMode = true;
            this.updateButtons();
        });
        this.addButton(this.privateButton);
        this.setButton = new TranslationButton(this, this.getGuiLeft() + 27, this.getGuiTop() + 116, 60, 20, MekanismLang.BUTTON_SET, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? this.clientPrivateCache.get(selection) : this.clientPublicCache.get(selection);
                this.setFrequency(freq.name);
            }
            this.updateButtons();
        });
        this.addButton(this.setButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 89, this.getGuiTop() + 116, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? this.clientPrivateCache.get(selection) : this.clientPublicCache.get(selection);
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.DEL_FREQ, this.currentHand, freq));
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, null));
                this.scrollList.clearSelection();
            }
            this.updateButtons();
        });
        this.addButton(this.deleteButton);
        this.teleportButton = new TranslationButton(this, this.getGuiLeft() + 42, this.getGuiTop() + 140, 92, 20, MekanismLang.BUTTON_TELEPORT, () -> {
            if (this.clientFreq != null && this.clientStatus == 1) {
                ClientTickHandler.portableTeleport((PlayerEntity)this.minecraft.field_71439_g, this.currentHand, this.clientFreq);
                this.minecraft.field_71439_g.func_71053_j();
            }
            this.updateButtons();
        });
        this.addButton(this.teleportButton);
        this.frequencyField = new TextFieldWidget(this.font, this.getGuiLeft() + 50, this.getGuiTop() + 104, 86, 11, "");
        this.addButton((Widget)this.frequencyField);
        this.frequencyField.func_146203_f(16);
        this.frequencyField.func_146185_a(false);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 137, this.getGuiTop() + 103, 11, 12, this.getButtonLocation("checkmark"), () -> {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
            this.updateButtons();
        }));
        this.updateButtons();
        if (this.isInit) {
            this.isInit = false;
        } else {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, this.clientFreq));
        }
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.frequencyField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.frequencyField.func_146180_a(s);
    }

    public void setFrequency(Frequency newFrequency) {
        this.clientFreq = newFrequency;
    }

    public void setPublicCache(List<Frequency> cache) {
        this.clientPublicCache = cache;
    }

    public void setPrivateCache(List<Frequency> cache) {
        this.clientPrivateCache = cache;
    }

    public void setStatus(byte status) {
        this.clientStatus = status;
    }

    public ITextComponent getSecurity(Frequency freq) {
        if (!freq.publicFreq) {
            return MekanismLang.PRIVATE.translateColored(EnumColor.DARK_RED, new Object[0]);
        }
        return MekanismLang.PUBLIC.translate(new Object[0]);
    }

    public void updateButtons() {
        if (this.getOwner() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : this.clientPrivateCache) {
                text.add(freq.name);
            }
        } else {
            for (Frequency freq : this.clientPublicCache) {
                text.add(MekanismLang.GENERIC_WITH_PARENTHESIS.translate(freq.name, freq.clientOwner).func_150254_d());
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.active = true;
            this.privateButton.active = false;
        } else {
            this.publicButton.active = false;
            this.privateButton.active = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? this.clientPrivateCache.get(this.scrollList.getSelection()) : this.clientPublicCache.get(this.scrollList.getSelection());
            this.setButton.active = this.clientFreq == null || !this.clientFreq.equals(freq);
            this.deleteButton.active = this.getOwner().equals(freq.ownerUUID);
        } else {
            this.setButton.active = false;
            this.deleteButton.active = false;
        }
        if (!this.itemStack.func_190926_b()) {
            this.teleportButton.active = this.clientFreq != null && this.clientStatus == 1;
        }
    }

    public void tick() {
        super.tick();
        this.updateButtons();
        this.frequencyField.func_146178_a();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.frequencyField.func_212955_f()) {
            if (keyCode == 256) {
                this.frequencyField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                this.setFrequency(this.frequencyField.func_146179_b());
                this.frequencyField.func_146180_a("");
                return true;
            }
            return this.frequencyField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.frequencyField.func_212955_f()) {
            if (Character.isDigit(c) || Character.isLetter(c) || FrequencyManager.SPECIAL_CHARS.contains(Character.valueOf(c))) {
                return this.frequencyField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(this.getName(), this.getXSize() / 2 - this.getStringWidth(this.getName()) / 2, 4, 0x404040);
        this.drawString(OwnerDisplay.of(this.getOwner(), this.getOwnerUsername()).getTextComponent(), 8, !this.itemStack.func_190926_b() ? this.getYSize() - 12 : this.getYSize() - 96 + 4, 0x404040);
        TranslationTextComponent frequencyComponent = MekanismLang.FREQUENCY.translate(new Object[0]);
        this.drawString((ITextComponent)frequencyComponent, 32, 81, 0x404040);
        TranslationTextComponent securityComponent = MekanismLang.SECURITY.translate("");
        this.drawString((ITextComponent)securityComponent, 32, 91, 0x404040);
        int frequencyOffset = this.getStringWidth((ITextComponent)frequencyComponent) + 1;
        if (this.clientFreq != null) {
            this.renderScaledText(this.clientFreq.name, 32 + frequencyOffset, 81, 0x797979, this.field_146999_f - 32 - frequencyOffset - 4);
            this.drawString(this.getSecurity(this.clientFreq), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, 0x797979);
        } else {
            this.drawString(MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + frequencyOffset, 81, 0x797979);
            this.drawString(MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, 0x797979);
        }
        this.renderScaledText((ITextComponent)MekanismLang.SET.translate(new Object[0]), 27, 104, 0x404040, 20);
        super.func_146979_b(mouseX, mouseY);
    }

    private UUID getOwner() {
        return ((IOwnerItem)this.itemStack.func_77973_b()).getOwnerUUID(this.itemStack);
    }

    private String getOwnerUsername() {
        return MekanismClient.clientUUIDMap.get(((IOwnerItem)this.itemStack.func_77973_b()).getOwnerUUID(this.itemStack));
    }

    public void setFrequency(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        Frequency newFreq = new Frequency(freq, null).setPublic(!this.privateMode);
        Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.SET_FREQ, this.currentHand, newFreq));
    }

    private ITextComponent getName() {
        return this.itemStack.func_200301_q();
    }
}

