/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiSetEnergy;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiResistiveHeater
extends GuiMekanismTile<TileEntityResistiveHeater, MekanismTileContainer<TileEntityResistiveHeater>> {
    private TextFieldWidget energyUsageField;

    public GuiResistiveHeater(MekanismTileContainer<TileEntityResistiveHeater> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 48, 23, 80, 28));
        this.addButton(new GuiInnerScreen(this, 48, 50, 68, 13));
        this.addButton(new GuiInnerScreen(this, 115, 50, 13, 13));
        this.addButton(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityResistiveHeater)this.tile).getEnergyContainer(), 164, 15));
        this.addButton(new GuiSecurityTab<TileEntityMekanism>((IGuiWrapper)this, this.tile));
        this.addButton(new GuiRedstoneControl(this, this.tile));
        this.addButton(new GuiEnergyInfo(((TileEntityResistiveHeater)this.tile).getEnergyContainer(), (IGuiWrapper)this));
        this.addButton(new GuiHeatInfo(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
        String prevEnergyUsage = this.energyUsageField != null ? this.energyUsageField.func_146179_b() : "";
        this.energyUsageField = new TextFieldWidget(this.font, this.getGuiLeft() + 49, this.getGuiTop() + 52, 66, 11, prevEnergyUsage);
        this.addButton((Widget)this.energyUsageField);
        this.energyUsageField.func_146203_f(7);
        this.energyUsageField.func_146185_a(false);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 116, this.getGuiTop() + 51, 11, 12, this.getButtonLocation("checkmark"), this::setEnergyUsage));
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.energyUsageField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.energyUsageField.func_146180_a(s);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(((TileEntityResistiveHeater)this.tile).getName(), this.getXSize() / 2 - this.getStringWidth(((TileEntityResistiveHeater)this.tile).getName()) / 2, 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 94 + 2, 0x404040);
        this.renderScaledText((ITextComponent)MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tile).getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), 50, 25, 52480, 76);
        this.renderScaledText((ITextComponent)MekanismLang.RESISTIVE_HEATER_USAGE.translate(EnergyDisplay.of(((TileEntityResistiveHeater)this.tile).getEnergyContainer().getEnergyPerTick())), 50, 41, 52480, 76);
        super.func_146979_b(mouseX, mouseY);
    }

    private void setEnergyUsage() {
        if (!this.energyUsageField.func_146179_b().isEmpty()) {
            try {
                Mekanism.packetHandler.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.ENERGY_USAGE, ((TileEntityResistiveHeater)this.tile).func_174877_v(), MekanismUtils.convertToJoules(FloatingLong.parseFloatingLong(this.energyUsageField.func_146179_b()))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.energyUsageField.func_146180_a("");
        }
    }

    public void tick() {
        super.tick();
        this.energyUsageField.func_146178_a();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.energyUsageField.func_212955_f()) {
            if (keyCode == 256) {
                this.energyUsageField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                this.setEnergyUsage();
                return true;
            }
            return this.energyUsageField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.energyUsageField.func_212955_f()) {
            if (Character.isDigit(c)) {
                return this.energyUsageField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }
}

