/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import mekanism.api.Upgrade;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiUpgradeScrollList;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiUpgradeManagement
extends GuiMekanismTile<TileEntityMekanism, MekanismTileContainer<TileEntityMekanism>> {
    private MekanismButton removeButton;
    private GuiUpgradeScrollList scrollList;
    private int supportedIndex;
    private int delay;

    public GuiUpgradeManagement(MekanismTileContainer<TileEntityMekanism> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.scrollList = new GuiUpgradeScrollList((IGuiWrapper)this, 24, 6, 66, 50, this.tile.getComponent());
        this.addButton(this.scrollList);
        this.addButton(new GuiElementHolder(this, 24, 56, 125, 14));
        this.addButton(new GuiInnerScreen(this, 90, 6, 59, 50));
        this.addButton(new GuiProgress(() -> this.tile.getComponent().getScaledUpgradeProgress(), ProgressType.INSTALLING, this, 154, 26));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 6, this.getGuiTop() + 6, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile))));
        this.removeButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 136, this.getGuiTop() + 57, 12, this.getButtonLocation("remove_upgrade"), () -> {
            if (this.scrollList.hasSelection()) {
                Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.REMOVE_UPGRADE, this.tile, this.scrollList.getSelection().ordinal()));
            }
        });
        this.addButton(this.removeButton);
        this.updateEnabledButtons();
    }

    public void tick() {
        super.tick();
        if (this.delay < 40) {
            ++this.delay;
        } else {
            this.delay = 0;
            ++this.supportedIndex;
            this.supportedIndex %= this.tile.getComponent().getSupportedTypes().size();
        }
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.removeButton.active = this.scrollList.hasSelection();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        Upgrade[] supported;
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 2, 0x404040);
        this.drawString((ITextComponent)MekanismLang.UPGRADES_SUPPORTED.translate(new Object[0]), 26, 59, 0x404040);
        if (this.scrollList.hasSelection()) {
            Upgrade selectedType = this.scrollList.getSelection();
            int amount = this.tile.getComponent().getUpgrades(selectedType);
            this.renderText((ITextComponent)MekanismLang.UPGRADE_TYPE.translate(selectedType), 92, 8, 0.6f);
            this.renderText((ITextComponent)MekanismLang.UPGRADE_COUNT.translate(amount, selectedType.getMax()), 92, 16, 0.6f);
            int text = 0;
            for (ITextComponent component : UpgradeUtils.getInfo(this.tile, selectedType)) {
                this.renderText(component, 92, 22 + 6 * text++, 0.6f);
            }
        } else {
            this.renderText((ITextComponent)MekanismLang.UPGRADE_NO_SELECTION.translate(new Object[0]), 92, 8, 0.8f);
        }
        Set<Upgrade> supportedTypes = this.tile.getComponent().getSupportedTypes();
        if (!supportedTypes.isEmpty() && (supported = supportedTypes.toArray(new Upgrade[0])).length > this.supportedIndex) {
            this.renderUpgrade(supported[this.supportedIndex], 80, 57, 0.8f);
            this.drawString(TextComponentUtil.build(supported[this.supportedIndex]), 96, 59, 0x404040);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    private void renderText(ITextComponent component, int x, int y, float size) {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)size, (float)size, (float)size);
        this.drawString(component, (int)(1.0f / size * (float)x), (int)(1.0f / size * (float)y), 52480);
        RenderSystem.popMatrix();
    }

    private void renderUpgrade(Upgrade type, int x, int y, float size) {
        this.renderItem(UpgradeUtils.getStack(type), (int)((float)x / size), (int)((float)y / size), size);
    }
}

