/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;

public class GuiRedstoneControl
extends GuiInsetElement<TileEntityMekanism> {
    private static final ResourceLocation DISABLED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "gun_powder.png");
    private static final ResourceLocation HIGH = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_high.png");
    private static final ResourceLocation LOW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_low.png");
    private static final ResourceLocation PULSE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_pulse.png");

    public GuiRedstoneControl(IGuiWrapper gui, TileEntityMekanism tile) {
        super(DISABLED, gui, tile, gui.getWidth(), 138, 26, 18);
    }

    public void renderToolTip(int mouseX, int mouseY) {
        this.displayTooltip(((IRedstoneControl)this.tile).getControlType().getTextComponent(), mouseX, mouseY);
    }

    public void onClick(double mouseX, double mouseY) {
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_REDSTONE_CONTROL, this.tile));
    }

    @Override
    protected ResourceLocation getOverlay() {
        switch (((IRedstoneControl)this.tile).getControlType()) {
            case HIGH: {
                return HIGH;
            }
            case LOW: {
                return LOW;
            }
            case PULSE: {
                return PULSE;
            }
        }
        return super.getOverlay();
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(EnumColor.DARK_RED);
    }
}

