/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import net.minecraft.util.text.ITextComponent;

public class ColorButton
extends MekanismButton {
    private final Supplier<EnumColor> colorSupplier;

    public ColorButton(IGuiWrapper gui, int x, int y, int width, int height, Supplier<EnumColor> colorSupplier, Runnable onPress, Runnable onRightClick) {
        super(gui, x, y, width, height, "", onPress, onRightClick, (onHover, xAxis, yAxis) -> {
            EnumColor color = (EnumColor)((Object)((Object)colorSupplier.get()));
            if (color != null) {
                gui.displayTooltip(color.getColoredName(), xAxis, yAxis);
            } else {
                gui.displayTooltip((ITextComponent)MekanismLang.NONE.translate(new Object[0]), xAxis, yAxis);
            }
        });
        this.colorSupplier = colorSupplier;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        EnumColor color = this.colorSupplier.get();
        if (color != null) {
            ColorButton.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)MekanismRenderer.getColorARGB(color, 1.0f));
            MekanismRenderer.resetColor();
        }
    }
}

