/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.Set;
import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiGauge<T>
extends GuiTexturedElement {
    private final GaugeType gaugeType;
    protected boolean dummy;
    protected T dummyType;

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y) {
        super(gaugeType.getGaugeOverlay().getBarOverlay(), gui, x, y, gaugeType.getGaugeOverlay().getWidth() + 2, gaugeType.getGaugeOverlay().getHeight() + 2);
        this.gaugeType = gaugeType;
    }

    public abstract int getScaledLevel();

    public abstract TextureAtlasSprite getIcon();

    public abstract ITextComponent getTooltipText();

    protected void applyRenderColor() {
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.renderExtendedTexture(this.gaugeType.getGaugeInfo().getResourceLocation(), this.gaugeType.getGaugeInfo().getSideWidth(), this.gaugeType.getGaugeInfo().getSideHeight());
        if (!this.dummy) {
            int scale = this.getScaledLevel();
            TextureAtlasSprite icon = this.getIcon();
            if (scale > 0 && icon != null) {
                this.applyRenderColor();
                this.drawTiledSprite(this.x + 1, this.y + 1, this.height - 2, this.width - 2, scale, icon);
                MekanismRenderer.resetColor();
            }
            GuiGauge.minecraft.field_71446_o.func_110577_a(this.getResource());
            GaugeOverlay gaugeOverlay = this.gaugeType.getGaugeOverlay();
            GuiGauge.blit((int)(this.x + 1), (int)(this.y + 1), (float)0.0f, (float)0.0f, (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight(), (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight());
        }
    }

    public void renderToolTip(int mouseX, int mouseY) {
        ItemStack stack = GuiGauge.minecraft.field_71439_g.field_71071_by.func_70445_o();
        EnumColor color = this.gaugeType.getGaugeInfo().getColor();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && color != null) {
            Object tile;
            if (this.guiObj instanceof GuiMekanismTile && (tile = ((GuiMekanismTile)this.guiObj).getTileEntity()) instanceof ISideConfiguration && this.getTransmission() != null) {
                DataType dataType = null;
                ConfigInfo config = ((ISideConfiguration)tile).getConfig().getConfig(this.getTransmission());
                if (config != null) {
                    Set<DataType> supportedDataTypes = config.getSupportedDataTypes();
                    for (DataType type : supportedDataTypes) {
                        if (type.getColor() != color) continue;
                        dataType = type;
                        break;
                    }
                }
                if (dataType == null) {
                    this.guiObj.displayTooltip(MekanismLang.GENERIC_PARENTHESIS.translateColored(color, color.getName()), mouseX, mouseY);
                } else {
                    this.guiObj.displayTooltip(MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, dataType, color.getName()), mouseX, mouseY);
                }
            }
        } else {
            this.guiObj.displayTooltip(this.getTooltipText(), mouseX, mouseY);
        }
    }

    public abstract TransmissionType getTransmission();

    public void setDummyType(T type) {
        this.dummyType = type;
    }
}

