/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.slot;

import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import net.minecraft.item.ItemStack;

public class GuiSlot
extends GuiTexturedElement {
    private static final int DEFAULT_SLOT_COLOR = -2130706433;
    private static final int INVALID_SLOT_COLOR = MekanismRenderer.getColorARGB(EnumColor.DARK_RED, 0.8f);
    private boolean hasValidityCheck;
    private Supplier<ItemStack> validityCheck = () -> ItemStack.field_190927_a;
    private Supplier<SlotOverlay> overlaySupplier;
    private SlotOverlay overlay;
    private GuiElement.IHoverable onHover;
    private boolean renderHover;

    public GuiSlot(SlotType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.active = false;
    }

    public GuiSlot validity(Supplier<ItemStack> validityCheck) {
        this.hasValidityCheck = true;
        this.validityCheck = validityCheck;
        return this;
    }

    public GuiSlot hover(GuiElement.IHoverable onHover) {
        this.onHover = onHover;
        return this;
    }

    public GuiSlot with(SlotOverlay overlay) {
        this.overlay = overlay;
        return this;
    }

    public GuiSlot with(Supplier<SlotOverlay> overlaySupplier) {
        this.overlaySupplier = overlaySupplier;
        return this;
    }

    public GuiSlot setRenderHover(boolean renderHover) {
        this.renderHover = renderHover;
        return this;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        ItemStack invalid;
        GuiSlot.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiSlot.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        if (this.hasValidityCheck && !(invalid = this.validityCheck.get()).func_190926_b()) {
            int xPos = this.x + 1;
            int yPos = this.y + 1;
            GuiSlot.fill((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)INVALID_SLOT_COLOR);
            MekanismRenderer.resetColor();
            this.guiObj.renderItem(invalid, xPos, yPos);
        }
        if (this.overlaySupplier != null) {
            this.overlay = this.overlaySupplier.get();
        }
        if (this.overlay != null) {
            GuiSlot.minecraft.field_71446_o.func_110577_a(this.overlay.getTexture());
            GuiSlot.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.overlay.getWidth(), (int)this.overlay.getHeight(), (int)this.overlay.getWidth(), (int)this.overlay.getHeight());
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, int xAxis, int yAxis) {
        if (this.renderHover && this.isHovered()) {
            int xPos = this.relativeX + 1;
            int yPos = this.relativeY + 1;
            GuiSlot.fill((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-2130706433);
            MekanismRenderer.resetColor();
        }
        if (this.isHovered()) {
            this.renderToolTip(xAxis, yAxis);
        }
    }

    public void renderToolTip(int mouseX, int mouseY) {
        if (this.onHover != null) {
            this.onHover.onHover(this, mouseX, mouseY);
        }
    }
}

