/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.filter.GuiModIDFilter;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.TagCache;
import mekanism.common.content.miner.MModIDFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.inventory.container.tile.filter.DMModIDFilterContainer;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityDigitalMiner;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiMModIDFilter
extends GuiModIDFilter<MModIDFilter, TileEntityDigitalMiner, DMModIDFilterContainer> {
    public GuiMModIDFilter(DMModIDFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.origFilter = container.getOrigFilter();
        this.filter = container.getFilter();
        this.isNew = container.isNew();
    }

    @Override
    protected void updateStackList(String modName) {
        this.iterStacks = TagCache.getModIDStacks(modName, true);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void addButtons() {
        this.addButton(new GuiInnerScreen(this, 33, 18, 111, 43));
        this.addButton(new GuiInnerScreen(this, 130, 46, 14, 14));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 18));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 148, 18).setRenderHover(true));
        this.saveButton = new TranslationButton(this, this.getGuiLeft() + 27, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_SAVE, () -> {
            if (!this.text.func_146179_b().isEmpty()) {
                this.setText();
            }
            if (((MModIDFilter)this.filter).getModID() != null && !((MModIDFilter)this.filter).getModID().isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter(((TileEntityDigitalMiner)this.tile).func_174877_v(), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityDigitalMiner)this.tile).func_174877_v(), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG);
            } else {
                this.status = MekanismLang.MODID_FILTER_NO_ID.translateColored(EnumColor.DARK_RED, new Object[0]);
                this.ticker = 20;
            }
        });
        this.addButton(this.saveButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 89, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityDigitalMiner)this.tile).func_174877_v(), true, this.origFilter, null));
            this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG);
        });
        this.addButton(this.deleteButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> this.sendPacketToServer(this.isNew ? PacketGuiButtonPress.ClickedTileButton.DM_SELECT_FILTER_TYPE : PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 148, this.getGuiTop() + 45, 14, 16, this.getButtonLocation("exclamation"), () -> {
            ((MModIDFilter)this.filter).requireStack = !((MModIDFilter)this.filter).requireStack;
        }, this.getOnHoverReplace((MinerFilter)this.filter)));
        this.checkboxButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 131, this.getGuiTop() + 47, 12, this.getButtonLocation("checkmark"), this::setText);
        this.addButton(this.checkboxButton);
    }
}

