/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.filter.GuiTextFilterBase;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.inventory.container.tile.filter.FilterContainer;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiTextFilter<FILTER extends IFilter<FILTER>, TILE extends TileEntityMekanism, CONTAINER extends FilterContainer<FILTER, TILE>>
extends GuiTextFilterBase<FILTER, TILE, CONTAINER> {
    protected List<ItemStack> iterStacks;
    protected int stackSwitch;
    protected int stackIndex;
    protected MekanismButton checkboxButton;

    protected GuiTextFilter(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    protected boolean wasTextboxKey(char c, int i) {
        return TransporterFilter.SPECIAL_CHARS.contains(Character.valueOf(c)) || super.wasTextboxKey(c, i);
    }

    @Override
    protected TextFieldWidget createTextField() {
        return new TextFieldWidget(this.font, this.getGuiLeft() + 35, this.getGuiTop() + 47, 95, 12, "");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = MekanismLang.STATUS_OK.translateColored(EnumColor.DARK_GREEN, new Object[0]);
        }
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0 && this.iterStacks != null && !this.iterStacks.isEmpty()) {
            this.stackSwitch = 20;
            if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                this.stackIndex = 0;
            } else if (this.stackIndex < this.iterStacks.size() - 1) {
                ++this.stackIndex;
            }
            this.renderStack = this.iterStacks.get(this.stackIndex);
        } else if (this.iterStacks != null && this.iterStacks.isEmpty()) {
            this.renderStack = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.tile instanceof TileEntityDigitalMiner) {
            this.drawMinerForegroundLayer(this.renderStack);
        } else if (this.tile instanceof TileEntityLogisticalSorter) {
            this.drawTransporterForegroundLayer(this.renderStack);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        this.text.mouseClicked(mouseX, mouseY, button);
        if (button == 0 && this.tile instanceof TileEntityDigitalMiner && this.filter instanceof MinerFilter) {
            this.minerFilterClickCommon(mouseX - (double)this.getGuiLeft(), mouseY - (double)this.getGuiTop(), (MinerFilter)this.filter);
        }
        return true;
    }
}

