/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToItemStackRecipe;
import mekanism.client.gui.element.GuiCrystallizerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;

public class ChemicalCrystallizerRecipeCategory
extends BaseRecipeCategory<GasToItemStackRecipe> {
    public ChemicalCrystallizerRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.CHEMICAL_CRYSTALLIZER, 5, 3, 147, 79);
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiCrystallizerScreen(this, 27, 13, new GuiCrystallizerScreen.IOreInfo(){

            @Override
            @Nonnull
            public GasStack getInputGas() {
                return GasStack.EMPTY;
            }

            @Override
            @Nullable
            public GasToItemStackRecipe getRecipe() {
                return null;
            }
        }));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 5, 4));
        this.guiElements.add(new GuiSlot(SlotType.EXTRA, this, 5, 64).with(SlotOverlay.PLUS));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT, this, 130, 56));
        this.guiElements.add(new GuiProgress(() -> (double)this.timer.getValue() / 20.0, ProgressType.LARGE_RIGHT, this, 53, 61));
    }

    public Class<? extends GasToItemStackRecipe> getRecipeClass() {
        return GasToItemStackRecipe.class;
    }

    public void setIngredients(GasToItemStackRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(recipe.getInput().getRepresentations()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, GasToItemStackRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 130 - this.xOffset, 56 - this.yOffset);
        itemStacks.set(0, recipe.getOutputDefinition());
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, true, 6 - this.xOffset, 5 - this.yOffset, 16, 58, recipe.getInput().getRepresentations(), true);
    }
}

