/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.IModelData;

public class ItemLayerWrapper
implements IBakedModel {
    private final IBakedModel internal;
    private ItemCameraTransforms.TransformType transform = ItemCameraTransforms.TransformType.NONE;
    public static Map<ItemCameraTransforms.TransformType, TransformationMatrix> transforms = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ItemLayerWrapper.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ItemLayerWrapper.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ItemLayerWrapper.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.NONE, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)).build();

    public ItemLayerWrapper(IBakedModel internal) {
        this.internal = internal;
    }

    public IBakedModel getBakedModel() {
        return this.internal;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.internal.getQuads(state, side, rand, extraData);
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.internal.func_200117_a(state, side, rand);
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.internal.isAmbientOcclusion(state);
    }

    public boolean func_177555_b() {
        return this.internal.func_177555_b();
    }

    public boolean func_230044_c_() {
        return this.internal.func_230044_c_();
    }

    public boolean func_177556_c() {
        return this.internal.func_177556_c();
    }

    public IBakedModel getInternal() {
        return this.internal;
    }

    public boolean func_188618_c() {
        return true;
    }

    @Nonnull
    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.internal.getParticleTexture(data);
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.internal.func_177554_e();
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.internal.func_177552_f();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return this.internal.getModelData(world, pos, state, tileData);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public IBakedModel handlePerspective(@Nonnull ItemCameraTransforms.TransformType type, MatrixStack matrix) {
        this.transform = type;
        TransformationMatrix tr = transforms.get(type);
        if (!tr.isIdentity()) {
            tr.push(matrix);
        }
        return this;
    }

    @Nonnull
    public ItemCameraTransforms.TransformType getTransform() {
        return this.transform;
    }

    private static TransformationMatrix get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TransformationMatrix(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Quaternion(ax, ay, az, true), new Vector3f(s, s, s), null);
    }
}

