/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.model.ModelDigitalMiner;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.MinerVisualRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityDigitalMiner;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;

@ParametersAreNonnullByDefault
public class RenderDigitalMiner
extends MekanismTileEntityRenderer<TileEntityDigitalMiner>
implements IWireFrameRenderer {
    private final ModelDigitalMiner model = new ModelDigitalMiner();

    public RenderDigitalMiner(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityDigitalMiner tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        this.performTranslations(tile, matrix);
        this.model.render(matrix, renderer, light, overlayLight, tile.getActive());
        matrix.func_227865_b_();
        if (tile.clientRendering) {
            profiler.func_76320_a("visuals");
            MinerVisualRenderer.render(tile, matrix, renderer);
            profiler.func_76319_b();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "digitalMiner";
    }

    public boolean isGlobalRenderer(TileEntityDigitalMiner tile) {
        return true;
    }

    @Override
    public void renderWireFrame(TileEntity tile, float partialTick, MatrixStack matrix, IVertexBuilder buffer, float red, float green, float blue, float alpha) {
        if (tile instanceof TileEntityDigitalMiner) {
            this.performTranslations((TileEntityDigitalMiner)tile, matrix);
            this.model.renderWireFrame(matrix, buffer, red, green, blue, alpha);
            matrix.func_227865_b_();
        }
    }

    private void performTranslations(TileEntityDigitalMiner tile, MatrixStack matrix) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 1.5, 0.5);
        MekanismRenderer.rotate(matrix, tile.getDirection(), 0.0f, 180.0f, 90.0f, 270.0f);
        matrix.func_227861_a_(0.0, 0.0, -1.0);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
    }
}

