/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.MekanismConfig;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public abstract class PlayerSound
extends LocatableSound
implements ITickableSound {
    @Nonnull
    private WeakReference<PlayerEntity> playerReference;
    private float lastX;
    private float lastY;
    private float lastZ;
    private float fadeUpStep = 0.1f;
    private float fadeDownStep = 0.1f;
    private boolean donePlaying = false;

    public PlayerSound(@Nonnull PlayerEntity player, @Nonnull SoundEvent sound) {
        super(sound, SoundCategory.PLAYERS);
        this.playerReference = new WeakReference<PlayerEntity>(player);
        this.lastX = (float)player.func_226277_ct_();
        this.lastY = (float)player.func_226278_cu_();
        this.lastZ = (float)player.func_226281_cx_();
        this.field_147659_g = true;
        this.field_147665_h = 0;
        this.field_147662_b = 0.1f;
    }

    @Nullable
    private PlayerEntity getPlayer() {
        return (PlayerEntity)this.playerReference.get();
    }

    public float func_147649_g() {
        PlayerEntity player = this.getPlayer();
        if (player != null) {
            this.lastX = (float)player.func_226277_ct_();
        }
        return this.lastX;
    }

    public float func_147654_h() {
        PlayerEntity player = this.getPlayer();
        if (player != null) {
            this.lastY = (float)player.func_226278_cu_();
        }
        return this.lastY;
    }

    public float func_147651_i() {
        PlayerEntity player = this.getPlayer();
        if (player != null) {
            this.lastZ = (float)player.func_226281_cx_();
        }
        return this.lastZ;
    }

    public void func_73660_a() {
        PlayerEntity player = this.getPlayer();
        if (player == null || !player.func_70089_S()) {
            this.donePlaying = true;
            this.field_147662_b = 0.0f;
            return;
        }
        if (this.shouldPlaySound(player)) {
            if (this.field_147662_b < 1.0f) {
                this.field_147662_b = Math.min(1.0f, this.field_147662_b + this.fadeUpStep);
            }
        } else if (this.field_147662_b > 0.0f) {
            this.field_147662_b = Math.max(0.0f, this.field_147662_b - this.fadeDownStep);
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }

    public abstract boolean shouldPlaySound(@Nonnull PlayerEntity var1);

    public float func_147653_e() {
        return super.func_147653_e() * MekanismConfig.client.baseSoundVolume.get();
    }

    public static enum SoundType {
        FLAMETHROWER,
        JETPACK,
        GAS_MASK;

    }
}

