/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IGasProvider;
import net.minecraft.tags.Tag;

public class FuelHandler {
    public static final FuelGas EMPTY_FUEL = new FuelGas(0, FloatingLong.ZERO);
    private static Map<Tag<Gas>, FuelGas> tagFuels = new Object2ObjectOpenHashMap();
    private static Map<Gas, FuelGas> fuels = new Object2ObjectOpenHashMap();

    public static void addGas(Tag<Gas> gasTag, int burnTicks, FloatingLong energyPerMilliBucket) {
        tagFuels.put(gasTag, new FuelGas(burnTicks, energyPerMilliBucket));
    }

    public static void addGas(IGasProvider gas, int burnTicks, FloatingLong energyPerMilliBucket) {
        fuels.put(gas.getGas(), new FuelGas(burnTicks, energyPerMilliBucket));
    }

    @Nonnull
    public static FuelGas getFuel(@Nonnull Gas gas) {
        for (Map.Entry<Gas, FuelGas> entry : fuels.entrySet()) {
            if (gas != entry.getKey()) continue;
            return entry.getValue();
        }
        for (Map.Entry<Gas, FuelGas> entry : tagFuels.entrySet()) {
            if (!gas.isIn((Tag<Gas>)((Tag)entry.getKey()))) continue;
            return entry.getValue();
        }
        return EMPTY_FUEL;
    }

    public static class FuelGas {
        public int burnTicks;
        public FloatingLong energyPerTick;

        public FuelGas(int duration, FloatingLong energyDensity) {
            this.burnTicks = duration;
            this.energyPerTick = duration == 0 ? energyDensity : energyDensity.divide(duration);
        }

        public boolean isEmpty() {
            return this == EMPTY_FUEL;
        }
    }
}

