/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.block.IHasTileEntity;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockBounding
extends Block
implements IHasTileEntity<TileEntityBoundingBlock>,
IStateFluidLoggable {
    private final boolean advanced;

    @Nullable
    private static BlockPos getMainBlockPos(IBlockReader world, BlockPos thisPos) {
        TileEntityBoundingBlock te = MekanismUtils.getTileEntity(TileEntityBoundingBlock.class, world, thisPos);
        if (te != null && te.receivedCoords && !thisPos.equals((Object)te.getMainPos())) {
            return te.getMainPos();
        }
        return null;
    }

    private static void removeMainBlock(World world, BlockPos thisPos) {
        BlockState state;
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, thisPos);
        if (mainPos != null && !(state = world.func_180495_p(mainPos)).isAir((IBlockReader)world, mainPos)) {
            world.func_217377_a(mainPos, false);
        }
    }

    public BlockBounding(boolean advanced) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.5f, 8.0f).func_208770_d());
        this.advanced = advanced;
        this.func_180632_j(BlockStateHelper.getDefaultState((BlockState)this.field_176227_L.func_177621_b()));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        BlockStateHelper.fillBlockStateContainer(this, builder);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return BlockStateHelper.getStateForPlacement(this, super.func_196258_a(context), context);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos);
        if (mainPos == null) {
            return ActionResultType.FAIL;
        }
        BlockState state1 = world.func_180495_p(mainPos);
        return state1.func_177230_c().func_225533_a_(state1, world, mainPos, player, hand, hit);
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            BlockBounding.removeMainBlock(world, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return ItemStack.field_190927_a;
        }
        BlockState state1 = world.func_180495_p(mainPos);
        return state1.func_177230_c().getPickBlock(state1, target, world, mainPos, player);
    }

    public boolean removedByPlayer(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, boolean willHarvest, IFluidState fluidState) {
        if (willHarvest) {
            return true;
        }
        BlockBounding.removeMainBlock(world, pos);
        return super.removedByPlayer(state, world, pos, player, false, fluidState);
    }

    public void func_180657_a(@Nonnull World world, PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, TileEntity te, @Nonnull ItemStack stack) {
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos);
        if (mainPos != null) {
            BlockState mainState = world.func_180495_p(mainPos);
            mainState.func_177230_c().func_180657_a(world, player, mainPos, mainState, MekanismUtils.getTileEntity((IBlockReader)world, mainPos), stack);
        } else {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
        world.func_217377_a(pos, false);
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        BlockPos mainPos;
        TileEntityBoundingBlock tile = MekanismUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)world, pos);
        if (tile != null) {
            tile.onNeighborChange(state);
        }
        if ((mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos)) != null) {
            world.func_180495_p(mainPos).func_215697_a(world, mainPos, neighborBlock, neighborPos, isMoving);
        }
    }

    @Deprecated
    public float func_180647_a(BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return super.func_180647_a(state, player, world, pos);
        }
        return world.func_180495_p(mainPos).func_185903_a(player, world, mainPos);
    }

    @Nonnull
    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return this.getTileType().func_200968_a();
    }

    @Override
    public TileEntityType<TileEntityBoundingBlock> getTileType() {
        if (this.advanced) {
            return MekanismTileEntityTypes.ADVANCED_BOUNDING_BLOCK.getTileEntityType();
        }
        return MekanismTileEntityTypes.BOUNDING_BLOCK.getTileEntityType();
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        BlockState mainState;
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return VoxelShapes.func_197880_a();
        }
        try {
            mainState = world.func_180495_p(mainPos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (world instanceof ChunkRenderCache) {
                world = ((ChunkRenderCache)world).field_212408_i;
                mainState = world.func_180495_p(mainPos);
            }
            Mekanism.logger.error("Error getting bounding block shape, for position {}, with main position {}. World of type {}", (Object)pos, (Object)mainPos, (Object)world.getClass().getName());
            return VoxelShapes.func_197880_a();
        }
        VoxelShape shape = mainState.func_215700_a(world, mainPos, context);
        BlockPos offset = pos.func_177973_b((Vec3i)mainPos);
        return shape.func_197751_a((double)(-offset.func_177958_n()), (double)(-offset.func_177956_o()), (double)(-offset.func_177952_p()));
    }

    @Nonnull
    @Deprecated
    public IFluidState func_204507_t(BlockState state) {
        return this.getFluid(state);
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        this.updateFluids(state, world, currentPos);
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Deprecated
    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull PathType type) {
        return false;
    }
}

