/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.chemical.infuse.BasicInfusionTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.IMekanismInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitGasHandler;
import mekanism.common.capabilities.chemical.item.RateLimitInfusionHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.item.RateLimitFluidHandler;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GaugeDropperContentsHandler
extends ItemCapabilityWrapper.ItemCapability
implements IMekanismFluidHandler,
IFluidHandlerItem,
IMekanismGasHandler,
IMekanismInfusionHandler {
    private static final int CAPACITY = 16000;
    private static final int TRANSFER_RATE = 256;
    private final IInfusionTank infusionTank;
    private final IGasTank gasTank;
    private final IExtendedFluidTank fluidTank = new RateLimitFluidHandler.RateLimitFluidTank(256, () -> 16000, BasicFluidTank.alwaysTrueBi, this::canInsert, BasicFluidTank.alwaysTrue, this);
    private List<IInfusionTank> infusionTanks;
    private List<IGasTank> gasTanks;
    private List<IExtendedFluidTank> fluidTanks;

    public static GaugeDropperContentsHandler create() {
        return new GaugeDropperContentsHandler();
    }

    private GaugeDropperContentsHandler() {
        this.gasTank = new RateLimitGasHandler.RateLimitGasTank(() -> 256L, () -> 16000L, BasicGasTank.alwaysTrueBi, this::canInsert, BasicGasTank.alwaysTrue, null, this);
        this.infusionTank = new RateLimitInfusionHandler.RateLimitInfusionTank(256L, () -> 16000L, BasicInfusionTank.alwaysTrueBi, this::canInsert, BasicInfusionTank.alwaysTrue, (IMekanismInfusionHandler)this);
    }

    private boolean canInsert(FluidStack fluidStack, AutomationType automationType) {
        return this.gasTank.isEmpty() && this.infusionTank.isEmpty();
    }

    private boolean canInsert(Gas gas, AutomationType automationType) {
        return this.fluidTank.isEmpty() && this.infusionTank.isEmpty();
    }

    private boolean canInsert(InfuseType infuseType, AutomationType automationType) {
        return this.fluidTank.isEmpty() && this.gasTank.isEmpty();
    }

    @Override
    protected void init() {
        this.fluidTanks = Collections.singletonList(this.fluidTank);
        this.gasTanks = Collections.singletonList(this.gasTank);
        this.infusionTanks = Collections.singletonList(this.infusionTank);
    }

    @Override
    protected void load() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            DataHandlerUtils.readTanks(this.getFluidTanks(null), ItemDataUtils.getList(stack, "FluidTanks"));
            DataHandlerUtils.readTanks(this.getGasTanks(null), ItemDataUtils.getList(stack, "GasTanks"));
            DataHandlerUtils.readTanks(this.getInfusionTanks(null), ItemDataUtils.getList(stack, "InfusionTanks"));
        }
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionTanks;
    }

    @Override
    public void onContentsChanged() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            ItemDataUtils.setList(stack, "FluidTanks", DataHandlerUtils.writeTanks(this.getFluidTanks(null)));
            ItemDataUtils.setList(stack, "GasTanks", DataHandlerUtils.writeTanks(this.getGasTanks(null)));
            ItemDataUtils.setList(stack, "InfusionTanks", DataHandlerUtils.writeTanks(this.getInfusionTanks(null)));
        }
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.getStack();
    }

    @Override
    protected void addCapabilityResolvers(CapabilityCache capabilityCache) {
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, this));
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.GAS_HANDLER_CAPABILITY, this));
        capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.INFUSION_HANDLER_CAPABILITY, this));
    }
}

