/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.tier.EnergyCubeTier;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnergyCubeEnergyContainer
extends BasicEnergyContainer {
    private final boolean isCreative;
    private final FloatingLongSupplier rate;

    public static EnergyCubeEnergyContainer create(EnergyCubeTier tier, @Nullable IMekanismStrictEnergyHandler energyHandler) {
        Objects.requireNonNull(tier, "Energy cube tier cannot be null");
        return new EnergyCubeEnergyContainer(tier, energyHandler);
    }

    private EnergyCubeEnergyContainer(EnergyCubeTier tier, @Nullable IMekanismStrictEnergyHandler energyHandler) {
        super(tier.getMaxEnergy(), alwaysTrue, alwaysTrue, energyHandler);
        this.isCreative = tier == EnergyCubeTier.CREATIVE;
        this.rate = tier::getOutput;
    }

    @Override
    protected FloatingLong getRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.get() : super.getRate(automationType);
    }

    @Override
    public FloatingLong insert(FloatingLong amount, Action action, AutomationType automationType) {
        return super.insert(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public FloatingLong extract(FloatingLong amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }
}

