/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.resolver.basic.EnergyCapabilityResolver;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackEnergyHandler
extends ItemCapabilityWrapper.ItemCapability
implements IMekanismStrictEnergyHandler {
    protected List<IEnergyContainer> energyContainers;

    protected abstract List<IEnergyContainer> getInitialContainers();

    @Override
    protected void init() {
        this.energyContainers = this.getInitialContainers();
    }

    @Override
    protected void load() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            DataHandlerUtils.readContainers(this.getEnergyContainers(null), ItemDataUtils.getList(stack, "EnergyContainers"));
        }
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            ItemDataUtils.setList(stack, "EnergyContainers", DataHandlerUtils.writeContainers(this.getEnergyContainers(null)));
        }
    }

    @Override
    protected void addCapabilityResolvers(CapabilityCache capabilityCache) {
        capabilityCache.addCapabilityResolver(new EnergyCapabilityResolver(this));
    }
}

