/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.heat;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BasicHeatCapacitor
implements IHeatCapacitor {
    @Nullable
    private final IMekanismHeatHandler heatHandler;
    private double heatCapacity;
    private final double inverseConductionCoefficient;
    private final double inverseInsulationCoefficient;
    protected double storedHeat;
    protected double heatToHandle;

    public static BasicHeatCapacitor create(double heatCapacity, @Nullable IMekanismHeatHandler heatHandler) {
        return BasicHeatCapacitor.create(heatCapacity, 1.0, 0.0, heatHandler);
    }

    public static BasicHeatCapacitor create(double heatCapacity, double inverseConductionCoefficient, double inverseInsulationCoefficient, @Nullable IMekanismHeatHandler heatHandler) {
        if (heatCapacity < 1.0) {
            throw new IllegalArgumentException("Heat capacity must be at least one");
        }
        if (inverseConductionCoefficient < 1.0) {
            throw new IllegalArgumentException("Inverse conduction coefficient must be at least one");
        }
        return new BasicHeatCapacitor(heatCapacity, inverseConductionCoefficient, inverseInsulationCoefficient, heatHandler);
    }

    protected BasicHeatCapacitor(double heatCapacity, double inverseConductionCoefficient, double inverseInsulationCoefficient, @Nullable IMekanismHeatHandler heatHandler) {
        this.heatCapacity = heatCapacity;
        this.inverseConductionCoefficient = inverseConductionCoefficient;
        this.inverseInsulationCoefficient = inverseInsulationCoefficient;
        this.heatHandler = heatHandler;
        this.storedHeat = heatCapacity * 300.0;
    }

    @Override
    public double getTemperature() {
        return this.getHeat() / this.getHeatCapacity();
    }

    @Override
    public double getInverseConduction() {
        return this.inverseConductionCoefficient;
    }

    @Override
    public double getInverseInsulation() {
        return this.inverseInsulationCoefficient;
    }

    @Override
    public double getHeatCapacity() {
        return this.heatCapacity;
    }

    @Override
    public void onContentsChanged() {
        if (this.heatHandler != null) {
            this.heatHandler.onContentsChanged();
        }
    }

    @Override
    public void handleHeat(double transfer) {
        this.heatToHandle += transfer;
    }

    public void update() {
        if (this.heatToHandle != 0.0) {
            this.storedHeat += this.heatToHandle;
            this.onContentsChanged();
        }
        this.heatToHandle = 0.0;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        NBTUtils.setDoubleIfPresent(nbt, "stored", heat -> {
            this.storedHeat = heat;
        });
        NBTUtils.setDoubleIfPresent(nbt, "heatCapacity", capacity -> {
            this.heatCapacity = capacity;
        });
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("stored", this.getHeat());
        nbt.func_74780_a("heatCapacity", this.getHeatCapacity());
        return nbt;
    }

    @Override
    public double getHeat() {
        return this.storedHeat;
    }

    @Override
    public void setHeat(double heat) {
        if (this.storedHeat != heat) {
            this.storedHeat = heat;
            this.onContentsChanged();
        }
    }

    public void setHeatCapacity(double newCapacity, boolean updateHeat) {
        if (updateHeat) {
            this.setHeat(this.getHeat() + (newCapacity - this.getHeatCapacity()) * 300.0);
        }
        this.heatCapacity = newCapacity;
    }
}

