/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.energy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.capabilities.holder.ConfigHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import net.minecraft.util.Direction;

public class ConfigEnergyContainerHolder
extends ConfigHolder
implements IEnergyContainerHolder {
    protected final List<IEnergyContainer> containers = new ArrayList<IEnergyContainer>();

    public ConfigEnergyContainerHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        super(facingSupplier, configSupplier);
    }

    void addContainer(@Nonnull IEnergyContainer container) {
        this.containers.add(container);
    }

    @Override
    protected TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction direction) {
        if (direction == null) {
            return this.containers;
        }
        TileComponentConfig config = (TileComponentConfig)this.configSupplier.get();
        if (config == null) {
            return this.containers;
        }
        ConfigInfo configInfo = config.getConfig(this.getTransmissionType());
        if (configInfo == null) {
            return this.containers;
        }
        RelativeSide side = RelativeSide.fromDirections((Direction)this.facingSupplier.get(), direction);
        ISlotInfo slotInfo = configInfo.getSlotInfo(side);
        if (slotInfo instanceof EnergySlotInfo && slotInfo.isEnabled()) {
            return ((EnergySlotInfo)slotInfo).getContainers();
        }
        return Collections.emptyList();
    }
}

