/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.heat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import net.minecraft.util.Direction;

public class HeatCapacitorHolder
implements IHeatCapacitorHolder {
    private final Map<RelativeSide, List<IHeatCapacitor>> directionalCapacitors = new EnumMap<RelativeSide, List<IHeatCapacitor>>(RelativeSide.class);
    private final List<IHeatCapacitor> capacitors = new ArrayList<IHeatCapacitor>();
    private final Supplier<Direction> facingSupplier;

    HeatCapacitorHolder(Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
    }

    void addCapacitor(@Nonnull IHeatCapacitor tank, RelativeSide ... sides) {
        this.capacitors.add(tank);
        for (RelativeSide side : sides) {
            this.directionalCapacitors.computeIfAbsent(side, k -> new ArrayList()).add(tank);
        }
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction direction) {
        if (direction == null || this.directionalCapacitors.isEmpty()) {
            return this.capacitors;
        }
        RelativeSide side = RelativeSide.fromDirections(this.facingSupplier.get(), direction);
        List<IHeatCapacitor> tanks = this.directionalCapacitors.get((Object)side);
        if (tanks == null) {
            return Collections.emptyList();
        }
        return tanks;
    }
}

