/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.proxy;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.ISidedGasHandler;
import mekanism.common.capabilities.holder.IHolder;
import mekanism.common.capabilities.proxy.ProxyHandler;
import net.minecraft.util.Direction;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ProxyGasHandler
extends ProxyHandler
implements IGasHandler {
    private final ISidedGasHandler gasHandler;

    public ProxyGasHandler(ISidedGasHandler gasHandler, @Nullable Direction side, @Nullable IHolder holder) {
        super(side, holder);
        this.gasHandler = gasHandler;
    }

    @Override
    public int getGasTankCount() {
        return this.gasHandler.getGasTankCount(this.side);
    }

    @Override
    public GasStack getGasInTank(int tank) {
        return this.gasHandler.getGasInTank(tank, this.side);
    }

    @Override
    public void setGasInTank(int tank, GasStack stack) {
        if (!this.readOnly) {
            this.gasHandler.setGasInTank(tank, stack, this.side);
        }
    }

    @Override
    public long getGasTankCapacity(int tank) {
        return this.gasHandler.getGasTankCapacity(tank, this.side);
    }

    @Override
    public boolean isGasValid(int tank, GasStack stack) {
        return !this.readOnly || this.gasHandler.isGasValid(tank, stack, this.side);
    }

    @Override
    public GasStack insertGas(int tank, GasStack stack, Action action) {
        return this.readOnly || this.readOnlyInsert.getAsBoolean() ? stack : this.gasHandler.insertGas(tank, stack, this.side, action);
    }

    @Override
    public GasStack extractGas(int tank, long amount, Action action) {
        return this.readOnly || this.readOnlyExtract.getAsBoolean() ? GasStack.EMPTY : this.gasHandler.extractGas(tank, amount, this.side, action);
    }

    @Override
    public GasStack insertGas(GasStack stack, Action action) {
        return this.readOnly || this.readOnlyInsert.getAsBoolean() ? stack : this.gasHandler.insertGas(stack, this.side, action);
    }

    @Override
    public GasStack extractGas(long amount, Action action) {
        return this.readOnly || this.readOnlyExtract.getAsBoolean() ? GasStack.EMPTY : this.gasHandler.extractGas(amount, this.side, action);
    }

    @Override
    public GasStack extractGas(GasStack stack, Action action) {
        return this.readOnly || this.readOnlyExtract.getAsBoolean() ? GasStack.EMPTY : this.gasHandler.extractGas(stack, this.side, action);
    }
}

