/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.proxy;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.ISidedInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.capabilities.holder.IHolder;
import mekanism.common.capabilities.proxy.ProxyHandler;
import net.minecraft.util.Direction;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ProxyInfusionHandler
extends ProxyHandler
implements IInfusionHandler {
    private final ISidedInfusionHandler infusionHandler;

    public ProxyInfusionHandler(ISidedInfusionHandler infusionHandler, @Nullable Direction side, @Nullable IHolder holder) {
        super(side, holder);
        this.infusionHandler = infusionHandler;
    }

    @Override
    public int getInfusionTankCount() {
        return this.infusionHandler.getInfusionTankCount(this.side);
    }

    @Override
    public InfusionStack getInfusionInTank(int tank) {
        return this.infusionHandler.getInfusionInTank(tank, this.side);
    }

    @Override
    public void setInfusionInTank(int tank, InfusionStack stack) {
        if (!this.readOnly) {
            this.infusionHandler.setInfusionInTank(tank, stack, this.side);
        }
    }

    @Override
    public long getInfusionTankCapacity(int tank) {
        return this.infusionHandler.getInfusionTankCapacity(tank, this.side);
    }

    @Override
    public boolean isInfusionValid(int tank, InfusionStack stack) {
        return !this.readOnly || this.infusionHandler.isInfusionValid(tank, stack, this.side);
    }

    @Override
    public InfusionStack insertInfusion(int tank, InfusionStack stack, Action action) {
        return this.readOnly || this.readOnlyInsert.getAsBoolean() ? stack : this.infusionHandler.insertInfusion(tank, stack, this.side, action);
    }

    @Override
    public InfusionStack extractInfusion(int tank, long amount, Action action) {
        return this.readOnly || this.readOnlyExtract.getAsBoolean() ? InfusionStack.EMPTY : this.infusionHandler.extractInfusion(tank, amount, this.side, action);
    }

    @Override
    public InfusionStack insertInfusion(InfusionStack stack, Action action) {
        return this.readOnly || this.readOnlyInsert.getAsBoolean() ? stack : this.infusionHandler.insertInfusion(stack, this.side, action);
    }

    @Override
    public InfusionStack extractInfusion(long amount, Action action) {
        return this.readOnly || this.readOnlyExtract.getAsBoolean() ? InfusionStack.EMPTY : this.infusionHandler.extractInfusion(amount, this.side, action);
    }

    @Override
    public InfusionStack extractInfusion(InfusionStack stack, Action action) {
        return this.readOnly || this.readOnlyExtract.getAsBoolean() ? InfusionStack.EMPTY : this.infusionHandler.extractInfusion(stack, this.side, action);
    }
}

