/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.common.MekanismLang;
import mekanism.common.command.ChunkCommand;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;

public class CommandMek {
    private static Map<UUID, Stack<BlockPos>> tpStack = new Object2ObjectOpenHashMap();

    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mek").requires(cs -> cs.func_197022_f() instanceof ServerPlayerEntity)).then(DebugCommand.register())).then(TestRulesCommand.register())).then(TpCommand.register())).then(TppopCommand.register())).then(ChunkCommand.register());
    }

    private static void teleport(Entity player, double x, double y, double z) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity mp = (ServerPlayerEntity)player;
            mp.field_71135_a.func_147364_a(x, y, z, mp.field_70177_z, mp.field_70125_A);
        } else {
            ClientPlayerEntity sp = (ClientPlayerEntity)player;
            sp.func_70012_b(x, y, z, sp.field_70177_z, sp.field_70125_A);
        }
    }

    private static class TppopCommand {
        private TppopCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpop").requires(cs -> cs.func_197034_c(4))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                UUID player = source.func_197022_f().func_110124_au();
                Stack playerLocations = tpStack.getOrDefault(player, new Stack());
                if (playerLocations.isEmpty()) {
                    source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TPOP_EMPTY.translate(new Object[0]), true);
                } else {
                    BlockPos lastPos = (BlockPos)playerLocations.pop();
                    tpStack.put(player, playerLocations);
                    CommandMek.teleport(source.func_197022_f(), lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p());
                    source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TPOP.translate(lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p(), playerLocations.size()), true);
                }
                return 0;
            });
        }
    }

    private static class TpCommand {
        private TpCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"tp").requires(cs -> cs.func_197034_c(4))).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                Entity entity = source.func_197022_f();
                UUID player = entity.func_110124_au();
                Stack<BlockPos> playerLocations = tpStack.getOrDefault(player, new Stack());
                playerLocations.push(entity.func_180425_c());
                tpStack.put(player, playerLocations);
                ILocationArgument location = Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location");
                Vec3d position = location.func_197281_a(source);
                CommandMek.teleport(entity, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TP.translate(position.func_82615_a(), position.func_82617_b(), position.func_82616_c()), true);
                return 0;
            }));
        }
    }

    private static class TestRulesCommand {
        private TestRulesCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"testrules").requires(cs -> cs.func_197034_c(4))).executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                MinecraftServer server = source.func_197028_i();
                GameRules rules = server.func_200252_aR();
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223601_d)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223607_j)).func_223570_a(false, server);
                ((GameRules.BooleanValue)rules.func_223585_a(GameRules.field_223617_t)).func_223570_a(false, server);
                source.func_197035_h().func_130014_f_().func_72877_b(2000L);
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_TEST_RULES.translate(new Object[0]), true);
                return 0;
            });
        }
    }

    private static class DebugCommand {
        private DebugCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").requires(cs -> cs.func_197034_c(4))).executes(ctx -> {
                MekanismAPI.debug = !MekanismAPI.debug;
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_DEBUG.translate(BooleanStateDisplay.OnOff.of(MekanismAPI.debug)), true);
                return 0;
            });
        }
    }
}

