/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.IMekanismConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class CachedResolvableConfigValue<TYPE, REAL> {
    private final ForgeConfigSpec.ConfigValue<REAL> internal;
    @Nullable
    private TYPE cachedValue;

    protected CachedResolvableConfigValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<REAL> internal) {
        this.internal = internal;
        config.addCachedValue(this);
    }

    protected abstract TYPE resolve(REAL var1);

    protected abstract REAL encode(TYPE var1);

    @Nonnull
    public TYPE get() {
        if (this.cachedValue == null) {
            this.cachedValue = this.resolve(this.internal.get());
        }
        return this.cachedValue;
    }

    public void set(TYPE value) {
        this.internal.set(this.encode(value));
        this.cachedValue = value;
    }

    public void clearCache() {
        this.cachedValue = null;
    }
}

