/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.Map;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.HashList;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;
import net.minecraftforge.fluids.IFluidBlock;

public class ThreadMinerSearch
extends Thread {
    private TileEntityDigitalMiner tile;
    public State state = State.IDLE;
    private Map<ChunkPos, BitSet> oresToMine = new Object2ObjectOpenHashMap();
    private Int2ObjectMap<MinerFilter<?>> replaceMap = new Int2ObjectOpenHashMap();
    private Map<Block, MinerFilter<?>> acceptedItems = new Object2ObjectOpenHashMap();
    private Region chunkCache;
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tile = tile;
    }

    public void setChunkCache(Region cache) {
        this.chunkCache = cache;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        HashList<MinerFilter<?>> filters = this.tile.getFilters();
        if (!this.tile.inverse && filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        BlockPos pos = this.tile.getStartingPos();
        int diameter = this.tile.getDiameter();
        int size = this.tile.getTotalSize();
        BlockPos minerPos = this.tile.func_174877_v();
        for (int i = 0; i < size; ++i) {
            Block info;
            BlockState state;
            if (this.tile.func_145837_r()) {
                return;
            }
            BlockPos testPos = pos.func_177982_a(i % diameter, i / diameter / diameter, i / diameter % diameter);
            if (minerPos.equals((Object)testPos) || MekanismUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)this.chunkCache, testPos) != null || (state = this.chunkCache.func_180495_p(testPos)).isAir((IBlockReader)this.chunkCache, testPos) || state.func_185887_b((IBlockReader)this.chunkCache, testPos) < 0.0f || (info = state.func_177230_c()) instanceof FlowingFluidBlock || info instanceof IFluidBlock) continue;
            MinerFilter filterFound = null;
            if (this.acceptedItems.containsKey(info)) {
                filterFound = this.acceptedItems.get(info);
            } else {
                ItemStack stack = new ItemStack((IItemProvider)info);
                if (this.tile.isReplaceStack(stack)) continue;
                for (MinerFilter minerFilter : filters) {
                    if (!minerFilter.canFilter(state)) continue;
                    filterFound = minerFilter;
                    break;
                }
                this.acceptedItems.put(info, filterFound);
            }
            if (this.tile.inverse != (filterFound == null)) continue;
            this.set(i, testPos);
            this.replaceMap.put(i, filterFound);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.tile.oresToMine = this.oresToMine;
        this.tile.replaceMap = this.replaceMap;
        this.chunkCache = null;
        this.tile.markDirty(false);
        this.tile.cachedToMine = this.found;
    }

    public void set(int i, BlockPos pos) {
        ChunkPos chunk = new ChunkPos(pos);
        this.oresToMine.computeIfAbsent(chunk, k -> new BitSet());
        this.oresToMine.get(chunk).set(i);
    }

    public void reset() {
        this.state = State.IDLE;
        this.chunkCache = null;
    }

    public static enum State implements IHasTextComponent
    {
        IDLE(MekanismLang.MINER_IDLE),
        SEARCHING(MekanismLang.MINER_SEARCHING),
        PAUSED(MekanismLang.MINER_PAUSED),
        FINISHED(MekanismLang.MINER_READY);

        private static final State[] MODES;
        private final ILangEntry langEntry;

        private State(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        public static State byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = State.values();
        }
    }
}

