/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import java.util.List;
import mekanism.api.Action;
import mekanism.common.Mekanism;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.tank.TankCache;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class TankUpdateProtocol
extends UpdateProtocol<SynchronizedTankData> {
    public static final int FLUID_PER_TANK = 64000;

    public TankUpdateProtocol(TileEntityDynamicTank tile) {
        super(tile);
    }

    @Override
    protected UpdateProtocol.CasingType getCasingType(BlockPos pos) {
        Block block = this.pointer.func_145831_w().func_180495_p(pos).func_177230_c();
        if (BlockTypeTile.is(block, MekanismBlockTypes.DYNAMIC_TANK)) {
            return UpdateProtocol.CasingType.FRAME;
        }
        if (BlockTypeTile.is(block, MekanismBlockTypes.DYNAMIC_VALVE)) {
            return UpdateProtocol.CasingType.VALVE;
        }
        return UpdateProtocol.CasingType.INVALID;
    }

    protected TankCache getNewCache() {
        return new TankCache();
    }

    @Override
    protected SynchronizedTankData getNewStructure() {
        return new SynchronizedTankData((TileEntityDynamicTank)this.pointer);
    }

    @Override
    protected MultiblockManager<SynchronizedTankData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedTankData> cache, MultiblockCache<SynchronizedTankData> merge) {
        TankCache tankCache = (TankCache)cache;
        TankCache mergeCache = (TankCache)merge;
        StorageUtils.mergeTanks(tankCache.getFluidTanks(null).get(0), mergeCache.getFluidTanks(null).get(0));
        tankCache.editMode = mergeCache.editMode;
        List<ItemStack> rejects = StackUtils.getMergeRejects(tankCache.getInventorySlots(null), mergeCache.getInventorySlots(null));
        if (!rejects.isEmpty()) {
            rejectedItems.addAll(rejects);
        }
        StackUtils.merge(tankCache.getInventorySlots(null), mergeCache.getInventorySlots(null));
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (!((SynchronizedTankData)this.structureFound).fluidTank.isEmpty()) {
            ((SynchronizedTankData)this.structureFound).fluidTank.setStackSize(Math.min(((SynchronizedTankData)this.structureFound).fluidTank.getFluidAmount(), ((SynchronizedTankData)this.structureFound).getTankCapacity()), Action.EXECUTE);
        }
    }
}

